/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.services.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;

/**
 * Generic Message Router Interface.
 *
 * @author kurt.stam@redhat.com
 * @deprecated Use {@link org.jboss.soa.esb.client.ServiceInvoker}.
 */
public abstract class MessageRouter {
    private static Logger logger = Logger.getLogger(MessageRouter.class);
    public final static String AGGEGRATOR_TAG = "aggregatorTag";
    public final static String SPLITTER_TIME_STAMP = "splitterTimeStamp";
    public static final String INTERNAL_SERVICE_CATEGORY = "JBossESB-Internal";
    public static final String DEAD_LETTER_SERVICE_NAME = "DeadLetterService";

    /**
     * Routes the message to the next destination.
     *
     * @param message
     * @return List of Strings containing the services to which the message was
     *         routed.
     */
    public abstract List<String> route(Message message)
            throws MessageRouterException;

    /**
     * Sends the message on to the service with the name(s) we just obtained
     * from the routing.
     *
     * @param serviceCategory -
     *                        the service category
     * @param serviceName     -
     *                        the service name
     * @param message         -
     *                        the message that needs routing and delivery
     * @deprecated Use the {@link org.jboss.soa.esb.client.ServiceInvoker}
     */
    @SuppressWarnings("unchecked")
    public synchronized static void deliverMessage(String serviceCategory, String serviceName, Message message) throws MessageRouterException {
        try {
            org.jboss.soa.esb.client.ServiceInvoker serviceInvoker = new org.jboss.soa.esb.client.ServiceInvoker(serviceCategory, serviceName);
            serviceInvoker.deliverAsync(message);
        } catch (MessageDeliverException e) {
            throw new MessageRouterException(e);
        }
    }

    /**
     * Sends the message on to the service with the name(s) we just obtained
     * from the routing.
     *
     * @param destinations -
     *                     Collection with the name of the destination services.
     * @param message      -
     *                     the message that needs routing and delivery
     * @deprecated Use the {@link org.jboss.soa.esb.client.MessageMulticaster}.
     */
    @SuppressWarnings("unchecked")
    public synchronized static void deliverMessages(Collection<String[]> destinations, Message message) throws MessageRouterException {
        String uuId = UUID.randomUUID().toString();
        int counter = 0;


        for (Iterator<String[]> i = destinations.iterator(); i.hasNext();) {
            //Only put tags on when routing to more then 1 destination
            if (destinations.size() > 1) {
                ArrayList<String> aggregatorTags = (ArrayList<String>) message.getProperties().getProperty(AGGEGRATOR_TAG);
                if (aggregatorTags == null) {
                    aggregatorTags = new ArrayList<String>();
                }
                String tag = uuId + ":" + ++counter + ":" + destinations.size() + ":" + new java.util.Date().getTime();
                aggregatorTags.add(tag);
                message.getProperties().setProperty(AGGEGRATOR_TAG, aggregatorTags);
                if (logger.isDebugEnabled()) {
                    logger.debug(AGGEGRATOR_TAG + "=" + tag);
                }
            }
            String[] destination = (String[]) i.next();
            deliverMessage(destination[0], destination[1], message);

        }
	}

}
