package org.jboss.soa.esb.message.body.content;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;

import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.body.content.InvalidPayloadException;
import org.jboss.soa.esb.message.body.content.MapBody;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/**
 * The Message payload contains a Map of serializable Objects that can be
 * inserted and retrieved as a Map.
 */

public interface MapBody extends Body
{
	public void setMap (Map<String, Serializable> payload);
	
	public boolean getBoolean (String name) throws InvalidPayloadException;
	public byte getByte (String name) throws InvalidPayloadException;
	public byte[] getBytes (String name) throws InvalidPayloadException;
	public float getFloat (String name) throws InvalidPayloadException;
	public double getDouble (String name) throws InvalidPayloadException;
	public char getChar (String name) throws InvalidPayloadException;
	public int getInt (String name) throws InvalidPayloadException;
	public long getLong (String name) throws InvalidPayloadException;
	public String getString (String name) throws InvalidPayloadException;
	
	public Enumeration<String> getMapNames ();
	
	public boolean itemExists (String name);
	
	public void setBoolean (String name, boolean val);
	public void setByte (String name, byte val);
	public void setBytes (String name, byte[] val);
	public void setFloat (String name, float val);
	public void setDouble (String name, double val);
	public void setChar (String name, char val);
	public void setInt (String name, int val);
	public void setLong (String name, long val);
	public void setString (String name, String val);

}