package org.jboss.soa.esb.message.body.content;

import java.io.IOException;

import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.body.content.BytesBody;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/**
 * The Message payload contains an arbitrary byte array that can be interpreted
 * by the application as basic Java types.
 * 
 * The instance must be placed into either a read mode or write mode. You can
 * switch between the two modes per instance, but each time you do it will reset
 * the buffer.
 * 
 * When finished, you <i>must</i> flush the instance to the underlying payload
 * implementation.
 */

public interface BytesBody extends Body
{

    public static final String BYTES_LOCATION = "org.jboss.soa.esb.message.content.bytes";
	
	public boolean readBoolean() throws IncompatibleModeException, IOException,
			InvalidPayloadException;
	
	public int readInt() throws IncompatibleModeException, IOException,
			InvalidPayloadException;
	
	public long readLong() throws IncompatibleModeException, IOException,
			InvalidPayloadException;
	
	public char readChar() throws IncompatibleModeException, IOException,
			InvalidPayloadException;
	
	public double readDouble() throws IncompatibleModeException, IOException,
			InvalidPayloadException;

	public float readFloat() throws IncompatibleModeException, IOException,
			InvalidPayloadException;

	public short readShort() throws IncompatibleModeException, IOException,
			InvalidPayloadException;

	public String readUTFString() throws IncompatibleModeException,
			IOException, InvalidPayloadException;
	
	public void writeBoolean(boolean b) throws IncompatibleModeException,
			IOException;
	
	public void writeInt(int i) throws IncompatibleModeException, IOException;

	public void writeLong(long l) throws IncompatibleModeException, IOException;

	public void writeChar(char c) throws IncompatibleModeException, IOException;

	public void writeDouble(double d) throws IncompatibleModeException,
			IOException;

	public void writeFloat(float f) throws IncompatibleModeException,
			IOException;
	
	public void writeShort(short s) throws IncompatibleModeException,
			IOException;

	public void writeUTFString(String s) throws IncompatibleModeException,
			IOException;
	
	/**
	 * Place the instance into read mode, so that the information within the
	 * byte stream can be retrieved.
	 * 
	 * @throws IOException
	 */

	public void readMode() throws IOException;

	/**
	 * Plce the instance into write mode, so that information may be placed
	 * within the byte stream.
	 * 
	 * @throws IOException
	 */

	public void writeMode() throws IOException;

	/**
	 * Reset the internal buffer. The mode will remain the same.
	 * 
	 * @throws IOException
	 */

	public void reset() throws IOException;

	/**
	 * Flush the internal byte array through to the payload.
	 * 
	 * @throws IOException
	 */

	public void flush() throws IOException;

}