package org.jboss.soa.esb.message;

import java.net.URI;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/**
 * Faults may be returned from a service in response to receiving and acting upon messages.
 * A fault consists of a unique code (MANDATORY) and a reason string (OPTIONAL). An OPTIONAL
 * throwable may also be returned.
 */

public interface Fault
{
	public static final String THROWABLE_CONTENT = "org.jboss.soa.esb.message.fault.throwable";
	public static final String DETAIL_CODE_CONTENT = "org.jboss.soa.esb.message.fault.detail.code";
	public static final String DETAIL_DESCRIPTION_CONTENT = "org.jboss.soa.esb.message.fault.detail.description";
	public static final String DETAIL_DETAIL_CONTENT = "org.jboss.soa.esb.message.fault.detail.detail";

	
	/**
	 * @return the unique code representing this fault.
	 */
	
	public URI getCode ();
	
	/**
	 * Set the unique code for this fault.
	 * 
	 * @param code the code.
	 */
	
	public void setCode (URI code);
	
	/**
	 * @return a String representing the reason for the fault. Typically used for
	 * logging purposes.
	 */
	
	public String getReason ();
	
	/**
	 * Set the optional reason for this fault.
	 * 
	 * @param reason the reason for the fault.
	 */
	
	public void setReason (String reason);
	
	/**
	 * Get the original Throwable. May be null, e.g., if the problem resulted
	 * from a non-Java environment.
	 * 
	 * @return the throwable.
	 */
	
	public Throwable getCause ();
	
	/**
	 * Set the original Throwable.
	 * 
	 * @param ex the throwable.
	 */
	
	public void setCause (Throwable ex);
}