package org.jboss.soa.esb.message;

import java.util.Set;

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author mark.little@jboss.com
 */

/**
 * The context is the section of the message containing information such as session
 * management, transaction information, security data etc. Entries in the context
 * may be ordered.
 * 
 * This section should never be passed by reference.
 */

public interface Context
{
    /**
     * Set the context value, replacing existing value if present.
     * @param key The context key.
     * @param value The context value.
     * @return the previous value of the context or null if not set.
     */
    public Object setContext(final String key, final Object value) ;
    
    /**
     * Retrieves the context value.
     * @param key The context key.
     * @return The value or null if not present.
     */
    public Object getContext(final String key) ;
    
    /**
     * Remove the context value.
     * @param key The context key.
     * @return The value of the context, or null if not present.
     */
    public Object removeContext(final String key) ;
    
    /**
     * Get the keys in the context.
     * @return the context keys.
     */
    public Set<String> getContextKeys() ;
    
    /**
     * Clear the context.
     */
    public void clearContext() ;
}