/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.message;

import java.util.Vector;
import java.util.Hashtable;

import javax.management.Notification;
import javax.management.NotificationListener;

/**
 * MessageAlertsMBean implementation.    Listens for MBean notifications from
 * services and actions and stores them in an ArrayList.
 * 
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a> 
 */
public class MessageAlerts 
	implements MessageAlertsMBean, NotificationListener {
	private static final String NOTIFICATION_MESSAGE = "notificationMessage";
	private static final String NOTIFICATION_SOURCE = "notificationSource";
	private static final String NOTIFICATION_SEQUENCE_LONG = "notificationSequence";
	private static final String NOTIFICATION_TIMESTAMP_LONG = "notificationTimestamp";
	private static final String NOTIFICATION_TYPE = "notificationType";

	private static Vector<Hashtable> alerts;
	
	public MessageAlerts() {
		alerts = new Vector<Hashtable>();
	}
			
	public void clearAlerts() {
		alerts = new Vector<Hashtable>();
	}

	public Vector<Hashtable> getAlerts() {
		return alerts;
	}

	public void handleNotification(Notification notification, Object handback) {
		String source = notification.getSource().toString();
		Hashtable<String,String> notifHash = new Hashtable<String, String>();
		notifHash.put(NOTIFICATION_MESSAGE, notification.getMessage());
		notifHash.put(NOTIFICATION_SOURCE, source);
		notifHash.put(NOTIFICATION_SEQUENCE_LONG, Long.toString(notification.getSequenceNumber()));
		notifHash.put(NOTIFICATION_TIMESTAMP_LONG, Long.toString(notification.getTimeStamp()));
		notifHash.put(NOTIFICATION_TYPE, notification.getType());
		alerts.add(notifHash);
	}
}
