/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.listeners.message;

import java.util.Observable;

/**
 * DeliveryObservableLogger is an observable which reports out to Observers.
 *
 * @author <a href="mailto:tcunning@redhat.com">tcunning@redhat.com</a>
 * @deprecated No longer used
 */
public class DeliveryObservableLogger extends Observable {
	private static DeliveryObservableLogger ref = null;
	
	/**
	 * Constructor.
	 */
	private DeliveryObservableLogger() {
	}

	/**
	 * Return the instance of DeliveryObservableLogger.
	 * @return instance of DeliveryObservableLogger
	 */
	public static DeliveryObservableLogger getInstance() {
		if (ref == null) {
			ref = new DeliveryObservableLogger();
		} 
		return ref;
	}

	/**
	 * Log the message to any registered observers.
	 * @param msb message status bean
	 */
	public void logMessage(MessageStatusBean msb) {
		setChanged();
		notifyObservers(msb);
	}	
}
