/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.lifecycle;

import java.util.EventObject;

public class ManagedLifecycleThreadStateEvent extends EventObject
{
    /**
     * The serial version uid for this event.
     */
    private static final long serialVersionUID = 7417604654035419987L;
    
    /**
     * The original state, prior to transition.
     */
    private final ManagedLifecycleThreadState origState ;
    /**
     * The new state, after transition.
     */
    private final ManagedLifecycleThreadState newState ;
    
    /**
     * Construct the managed lifecycle state event.
     * @param instance The managed instance 
     * @param origState The original state, prior to transition
     * @param newState The new state after transition
     */
    public ManagedLifecycleThreadStateEvent(final AbstractThreadedManagedLifecycle instance,
        final ManagedLifecycleThreadState origState, final ManagedLifecycleThreadState newState)
    {
        super(instance) ;
        this.origState = origState ;
        this.newState = newState ;
    }

    /**
     * Get the managed lifecycle instance.
     * @return The managed lifecycle instance.
     */
    public ManagedLifecycle getManagedInstance()
    {
        return (ManagedLifecycle)getSource() ;
    }

    /**
     * Get the original state, prior to transition.
     * @return The original state.
     */
    public ManagedLifecycleThreadState getOriginalState()
    {
        return origState ;
    }

    /**
     * Get the new state after transition.
     * @return The new state.
     */
    public ManagedLifecycleThreadState getNewState()
    {
        return newState ;
    }
    
    /**
     * Return a String representation of this event.
     * @return  The string representation of this event.
     */
    public String toString()
    {
        return getClass().getName() + "[instance=" + getManagedInstance() + ", original state " + origState + ", new state " + newState + "]" ;
    }
}
