/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb.listeners.gateway;

import java.io.File;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;

/**
 * Composer that simply set the file name as the message contents.
 * <p>
 * This can be used when handling large files and one wants to avoid parsing the file contents.<br>
 * <pre>
 * Usage (for example inside a fs-listener element ):
 * &lt;property name="composer-class" value="org.jboss.soa.esb.listeners.gateway.LocalFileNameMessageComposer"/>
 * </pre>
 * 
 * @author <a href="mailto:daniel.bevenius@gmail.com">Daniel Bevenius</a>			
 * @since 4.3
 *
 */
public class LocalFileNameMessageComposer<T extends File> extends LocalFileMessageComposer<T>
{
	/**
	 * Simply returns the absolute path of the passed in file.
	 * 
	 * @param inputFile	- input File object
	 * @return Object	- String that contains the absulute path to the file.
	 */
    protected Object getPayload( final T inputFile )
    {
        return inputFile.getAbsolutePath();
    }

	@Override
	public void setConfiguration( ConfigTree config ) throws ConfigurationException
	{
		super.setConfiguration( config );
	}
    
    

}
