/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */

package org.jboss.soa.esb.listeners.config.mappers120;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.ListenerTagNames;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.SecurityDocument.Security;
import org.jboss.soa.esb.listeners.config.xbeanmodel120.ServiceDocument.Service;
import org.w3c.dom.Element;

/**
 * Performs the mapping of XSD based configuration service actions onto a
 * "ConfigTree" style listener configuration.
 *
 * @author <a href="mailto:dbevenius@jboss.com">Daniel Bevenius</a>
 */
public class SecurityMapper
{
	private SecurityMapper() {}

	/**
	 * Perform the mapping.
	 *
	 * @param toConfigTree
	 *            The listener ConfigTree to which the actions are to be added.
	 * @param service
	 *            The Service to which the listener is bound. The Service defines the actions.
	 * @throws org.jboss.soa.esb.ConfigurationException
	 */
	public static void map( final Element toConfigTree, final Service service ) throws ConfigurationException
	{
		final Security security = service.getSecurity();
		if ( security != null)
		{
    		final Element securityElement = YADOMUtil.addElement( toConfigTree, ListenerTagNames.SECURITY_TAG );
			MapperUtil.serialize( security, securityElement );
		}
	}
}