/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2009
 */
package org.jboss.soa.esb.listeners.config;

import org.jboss.internal.soa.esb.publish.ContractProvider;
import org.jboss.soa.esb.Service;

/**
 * ServiceContract.
 * 
 * @author dward at jboss.org
 */
public class ServiceContract
{
	
	private final Service service;
	private final String description;
	private final ContractProvider contractProvider;
	
	public ServiceContract(Service service, String description, ContractProvider contractProvider)
	{
		this.service = service;
		this.description = description;
		this.contractProvider = contractProvider;
	}
	
	public Service getService()
	{
		return service;
	}
	
	public String getDescription()
	{
		return description;
	}
	
	public ContractProvider getContractProvider()
	{
		return contractProvider;
	}

}
