/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.soa.esb.listeners.config;

import java.util.List;

import org.jboss.internal.soa.esb.publish.ContractProviderLifecycleResource;
import org.jboss.internal.soa.esb.publish.ContractReferencePublisher;
import org.jboss.soa.esb.lifecycle.LifecycleResourceManager;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleController;
import org.jboss.system.ServiceMBeanSupport;

/**
 * comment
 *
 * @author <a href="bill@jboss.com">Bill Burke</a>
 * @version $Revision: 1.1 $
 */
public class JBoss4ESBDeployment extends ServiceMBeanSupport implements JBoss4ESBDeploymentMBean
{
   private final String jbossEsbXml;
   private String deploymentName ;
   private List<ContractReferencePublisher> publishers ;
   private List<ServiceContract> serviceContracts;
   private ManagedLifecycleController controller;
   private ClassLoader classloader;

   public JBoss4ESBDeployment(String jbossEsbXml, final String deploymentName)
   {
      this.jbossEsbXml = jbossEsbXml;
      this.deploymentName = deploymentName ;
   }

   public String getJbossEsbXml()
   {
      return jbossEsbXml;
   }

   public String getJbossEsbXmlAsHtml()
   {
      return jbossEsbXml.replace("<", "&lt;").replace(">", "&gt;");
   }

   public void setClassloader(ClassLoader classloader)
   {
      this.classloader = classloader;
   }

   public void setPublishers(final List<ContractReferencePublisher> publishers)
   {
       this.publishers = publishers ;
   }
   
   public void setServiceContracts(final List<ServiceContract> serviceContracts)
   {
	   this.serviceContracts = serviceContracts;
   }

   public ManagedLifecycleController getController()
   {
      return controller;
   }
   
   public String getDeploymentName()
   {
       return deploymentName ;
   }
   
   public void setDeploymentName(final String deploymentName)
   {
       this.deploymentName = deploymentName ;
   }
   
   public List<ContractReferencePublisher> getPublishers()
   {
       return publishers ;
   }

   @Override
   public void createService()
   {
      ClassLoader old = Thread.currentThread().getContextClassLoader();
      try
      {
         Thread.currentThread().setContextClassLoader(classloader);
         LifecycleResourceManager.getSingleton().associateDeployment(deploymentName) ;
      }
      finally
      {
         Thread.currentThread().setContextClassLoader(old);
      }
   }

   @Override
   public void startService() throws Exception
   {
      ClassLoader old = Thread.currentThread().getContextClassLoader();
      try
      {
         Thread.currentThread().setContextClassLoader(classloader);
         controller = Configuration.create(jbossEsbXml, serviceName, publishers);
         controller.start();
         ContractProviderLifecycleResource.putContractProviders(serviceContracts);
      }
      finally
      {
         Thread.currentThread().setContextClassLoader(old);
      }

   }

   @Override
   public void stopService() throws Exception
   {
      ClassLoader old = Thread.currentThread().getContextClassLoader();
      try
      {
         Thread.currentThread().setContextClassLoader(classloader);
         ServicePublisher.removeServicePublishers(controller);
         controller.stop();
      }
      finally
      {
         Thread.currentThread().setContextClassLoader(old);
      }
   }

   @Override
   public void destroyService() throws Exception
   {
      ClassLoader old = Thread.currentThread().getContextClassLoader();
      try
      {
         Thread.currentThread().setContextClassLoader(classloader);
         LifecycleResourceManager.getSingleton().disassociateDeployment(deploymentName) ;
         LifecycleResourceManager.getSingleton().destroyResources() ;
      }
      finally
      {
         Thread.currentThread().setContextClassLoader(old);
      }
   }
}
