/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.http.protocol;

import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.jboss.soa.esb.ConfigurationException;

import java.util.Properties;

/**
 * {@link ProtocolSocketFactory} Builder.
 * <p/>
 * This builder is needed because some of the HttpClient ProtocolSocketFactory
 * are not easily created and configured reflectively.
 * <p/>
 * <b>Implementations must provide a default (no-arg) constructor.</b>
 *
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public interface ProtocolSocketFactoryBuilder {

    /**
     * Set the builder configuration.
     * @param configuration The configuration.
     * @throws ConfigurationException Bad configuration.
     */
    public void setConfiguration(Properties configuration) throws ConfigurationException;

    /**
     * Create a new instance of the {@link ProtocolSocketFactory} based on the supplied
     * {@link org.jboss.soa.esb.http.HttpClientFactory} configuration.
     *
     * @return The configured ProtocolSocketFactory implementation. 
     * @throws ConfigurationException Bad configuration.
     */
    public ProtocolSocketFactory newInstance() throws ConfigurationException;
}
