/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.helpers;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.log4j.Logger;

/**
 * Obtains JNDI naming context.
 * 
 * @deprecated {@link org.jboss.soa.esb.helpers.NamingContextPool}
 */
public class NamingContext 
{
	/**
	 * Logger for this class
	 */
	private static final Logger _logger = Logger.getLogger(NamingContext.class);
	public static final int MAX_RETRIES = 10;
	public static final String JBOSS_PROVIDER_URL = "localhost";
	public static final String JBOSS_INITIAL_CONTEXT_FACTORY = "org.jnp.interfaces.NamingContextFactory";
	public static final String JBOSS_URL_PKG_PREFIX = ""; //"org.jboss.naming:org.jnp.interfaces"
    private static ConcurrentHashMap<String,Context> _contextCache = new ConcurrentHashMap<String, Context>();
	/**
	 * Tries to connect to the server to obtain the server Context.
	 * 
	 * @param properties - the JNDI environment.
	 * @return the InitialContext.
	 */
	public static Context getServerContext(Properties properties) 
	{
        String key = getKey(properties);
	    if (_contextCache.containsKey(key)) {
            return _contextCache.get(key);
        }
		boolean bCtxOK = false;
		Context oCtx = null;
		for (int i1 = 0; (!bCtxOK) && i1 < MAX_RETRIES; i1++) {
			// check if context is valid
			try {
                oCtx = new InitialContext(properties);
				oCtx.list("__dummy2@#$%");
				bCtxOK = true;
			} catch (NamingException nex) {
				bCtxOK = true;
			}
		}
		if (bCtxOK) {
            _contextCache.put(key, oCtx);
			return oCtx;
		} else {
			_logger.error("Can't connect to JNDI Server <" + properties.get(Context.PROVIDER_URL) + ">");
			return null;
		}
	}
    /**
     * Refreshing the cached JNDI context, return the new context.
     * @param properties
     * @return Context
     */
    public static Context getFreshServerContext(Properties properties)
    {
        String key = getKey(properties);
        Context context = _contextCache.get(key);
        if (context != null) {
            try {
                context.close();
            } catch (NamingException ne) {
                _logger.warn("Could not close JNDI connection.");
            }
            _contextCache.remove(key);
        }
        return getServerContext(properties);
    }
    /**
     * Takes properties and serializes this into a long string which is
     * the key into the contextCache.
     * @param properties - property Bag.
     * @return key into the contextCache.
     */
    private static String getKey(Properties properties) 
    {
        //Can't handle nulls
        if (properties==null) {
            properties=new Properties();
        }
        //Contruct the composite key, buy serializing the properties into one String.
        StringBuffer compositeKey= new StringBuffer("-");
        for (Object keyObject : properties.keySet()) {
            String key = (String) keyObject;
            String value=(String)properties.getProperty(key);
            compositeKey.append(key).append("=").append(value).append("-");
        }
        return compositeKey.toString();
    }
    /**
     * Closes all Contexts, and removes them from the contextCache.
     */
    public static void closeAllContexts()
    {
        for (Map.Entry<String, Context> entry : _contextCache.entrySet()) {
            final String key = entry.getKey() ;
            try {
                _logger.debug("Closing JNDI connection for key: " + key);
                final Context context = entry.getValue();
                if (context != null) {
                    context.close();
                }
            } catch (NamingException ne) {
                _logger.warn("Could not close JNDI connection for key: " + key);
             }
            _contextCache.remove(key);
        }
    }

}
