/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.soa.esb.actions;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.registry.RegistryException;
import org.jboss.soa.esb.services.routing.MessageRouterException;
/**
 * ContentBasedRouter implements the Content Based Routing pattern. 
 * It routes a message to one or more destination services based on the message content 
 * and the rule set it is evaluating it  against. 
 * <p/>
 * For configuration details see
 * 
 * @author <a href="mailto:schifest@heuristica.com.ar">schifest@heuristica.com.ar</a>
 * @author kstam@jboss.com
 * 
 * @see ContentBasedWiretap
 *
 */
public class ContentBasedRouter extends ContentBasedWiretap
{
    public ContentBasedRouter(ConfigTree config) throws ConfigurationException, RegistryException, MessageRouterException
    {
        super(config) ;
    }
    /** Route the message to one or more destinations, using the ContentBasedRouter to figure out
     *  to which destinations it is going to be routed too.
     *  
     * @param message
     * @return Message
     * @throws ActionProcessingException
     */
    public Message process(Message message) throws ActionProcessingException
    {
        super.process(message) ;
        return null ;
    }

    /** 
     * @deprecated no longer needed, leaving this in here for backwards compatibility,
     * use the default "process".
     * */
    public Message split(Message message) throws ActionProcessingException
    {
        _logger.warn("Depricated, please use the default 'process' method in your configuration");
        return process(message);
    }

    protected static final Logger _logger = Logger.getLogger(ContentBasedRouter.class);
}
