/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.soa.esb.actions;

import java.net.URI;

import javax.xml.namespace.QName;

import org.jboss.soa.esb.listeners.message.errors.Factory;
import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.Fault;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.format.MessageFactory;

/**
 * Exception used to specify SOAP code/reason/detail equivalents in a fault.
 * 
 * @author <href='mailto:kevin.conner@jboss.com'>Kevin Conner</a>
 */
public class ActionProcessingDetailFaultException extends ActionProcessingFaultException
{
    /**
     * The serial version UID for this class.
     */
    private static final long serialVersionUID = -2402515550073037696L ;

    public ActionProcessingDetailFaultException(final QName code, final String description, final String detail)
    {
        this(code, description, detail, null) ;
    }
    
    public ActionProcessingDetailFaultException(final QName code, final String description, final String detail, final Throwable th)
    {
        super(getFaultMessage(code, description, detail, th), description) ;
    }
    
    private static Message getFaultMessage(final QName code, final String description, final String detail, final Throwable th)
    {
        final Message message = MessageFactory.getInstance().getMessage() ;
        final Body body = message.getBody() ;
        final Fault fault = message.getFault() ;
        if (th != null)
        {
            fault.setCause(th);
            fault.setReason(th.toString()) ;
        }
        fault.setCode(URI.create(Factory.PROCESSING_ERROR)) ;
        
        body.add(Fault.DETAIL_CODE_CONTENT, code) ;
        if (description != null)
        {
            body.add(Fault.DETAIL_DESCRIPTION_CONTENT, description) ;
        }
        if (detail != null)
        {
            body.add(Fault.DETAIL_DETAIL_CONTENT, detail) ;
        }
        fault.setReason(description) ;
        
        return message ;
    }
}
