/*
 * JBoss, Home of Professional Open Source Copyright 2006, JBoss Inc., and
 * individual contributors as indicated by the @authors tag. See the
 * copyright.txt in the distribution for a full listing of individual
 * contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.soa.esb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * Just prints the contents of the VERSION file to standard out.
 * 
 * @author <a href="mailto:daniel.bevenius@gmail.com">Daniel Bevenius</a>				
 *
 */
public class Version
{
	private static final String VERSION_FILENAME = "/VERSION";
	
	public static void main( String[] args )
	{
		BufferedReader br = null;
		InputStream is = Version.class.getResourceAsStream( VERSION_FILENAME );
		if ( is != null )
		{
			br = new BufferedReader( new InputStreamReader( is ) );
			String line = null;
			try
			{
				while ( ( line = br.readLine() ) != null) 
					System.out.println(line);
			} 
			catch (IOException e)
			{
				e.printStackTrace();
			}
			finally
			{
				if ( br != null ) try { br.close(); } catch (IOException e) { e.printStackTrace(); }
			}
		}
	}
}
