/*
 * JBoss, Home of Professional Open Source Copyright 2008, Red Hat Middleware
 * LLC, and individual contributors by the @authors tag. See the copyright.txt
 * in the distribution for a full listing of individual contributors.
 * 
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA, or see the FSF
 * site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.webservice;

import java.util.Set;

import javax.management.ObjectName;

import org.jboss.internal.soa.esb.publish.AbstractContractReferencePublisher;
import org.jboss.soa.esb.Service;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;

public class ESBServiceContractReferencePublisher extends AbstractContractReferencePublisher {
	
	private final String endpointName;
	private String endpointAddress;
	
	public ESBServiceContractReferencePublisher(Service service, String description, String endpointName) {
		super(service, description);
		this.endpointName = endpointName;
	}

	public String getEndpointAddress() {
		if (endpointAddress != null) {
			return endpointAddress;
		}
		
		SPIProvider spiProv = SPIProviderResolver.getInstance().getProvider();
		EndpointRegistryFactory factory = spiProv
				.getSPI(EndpointRegistryFactory.class);
		EndpointRegistry registry = factory.getEndpointRegistry();
		Set<ObjectName> objectNames = registry.getEndpoints();

		for (ObjectName objectName : objectNames) {
			String endpoint = objectName
					.getKeyProperty(Endpoint.SEPID_PROPERTY_ENDPOINT);

			if (endpoint != null && endpoint.equals(endpointName)) {
				Endpoint ep = registry.getEndpoint(objectName);
				endpointAddress = ep.getAddress();
				return endpointAddress;
			}
		}

		return null;
	}
}
