/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * (C) 2005-2008, JBoss Inc.
 */
package org.jboss.internal.soa.esb.webservice;

import org.jboss.internal.soa.esb.util.NullWriter;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * Webservice response filter.
 * 
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class ESBResponseFilter implements Filter {

    private static final String POST = "POST" ;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        final boolean filter ;
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest ;
            filter = POST.equals(httpServletRequest.getMethod()) ;
        } else {
            filter = false ;
        }
        
        if (filter) {
            filterChain.doFilter(servletRequest, new OneWayResponseWrapper((HttpServletResponse) servletResponse));
            servletResponse.setContentType("text/xml");
            servletResponse.setContentLength(0);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }

    /**
     * OneWay response wrapper.
     * <p/>
     * Filters out the response i.e. ensures that the response body is empty.
     */
    private static class OneWayResponseWrapper extends HttpServletResponseWrapper {

        public OneWayResponseWrapper(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
        }

        public PrintWriter getWriter() throws IOException {
            return new PrintWriter(new NullWriter());
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return new NullServletOutputStream();
        }
    }

    /**
     * Null {@link ServletOutputStream}.
     */
    private static class NullServletOutputStream extends ServletOutputStream {
        public void write(int b) throws IOException {
        }
        public void write(byte b[]) throws IOException {
        }
        public void write(byte b[], int off, int len) throws IOException {
        }
    }
}
