/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * (C) 2005-2008, JBoss Inc.
 */
package org.jboss.internal.soa.esb.util;

import java.io.Writer;
import java.io.IOException;

/**
 * Null {@link Writer}.
 * 
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class NullWriter extends Writer {

    public NullWriter() {
        super();
    }

    public NullWriter(Object lock) {
        super(lock);
    }

    public void write() throws IOException {
        
    }

    public void write(int c) throws IOException {
        write();
    }

    public void write(char cbuf[]) throws IOException {
        write();
    }

    public void write(String str) throws IOException {
        write();
    }

    public void write(String str, int off, int len) throws IOException {
        write();
    }

    public Writer append(CharSequence csq) throws IOException {
        write();
        return this;
    }

    public Writer append(CharSequence csq, int start, int end) throws IOException {
        write();
        return this;
    }

    public Writer append(char c) throws IOException {
        write();
        return this;
    }

    public void write(char cbuf[], int off, int len) throws IOException {
        write();
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }
}
