/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.internal.soa.esb.publish;

import org.jboss.soa.esb.addressing.EPR;

import javax.servlet.http.HttpServletRequest;

/**
 * Action contract Publisher.
 *
 * @author
 */
public interface ServletContractPublisher extends ContractPublisher {

    /**
     * Get the contract information within a servlet context.
     * <p/>
     * A Service may publish a number of addressable endpoints. The publisher
     * will likely return different contract info depending on the endpoint EPR.
     * <p/>
     * This info can be stored and published from a global registry of some sort.
     *
     * @param epr Endpoint EPR.
     * @param servletRequest The servlet request context.
     * @return Contract information.
     */
    public ContractInfo getContractInfo(final EPR epr, final HttpServletRequest servletRequest) ;
}
