/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author daniel.brum@jboss.com
 */

package org.jboss.internal.soa.esb.persistence.manager;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.persistence.manager.ConnectionManager;
import org.jboss.soa.esb.services.security.PasswordUtil;

import com.mchange.v2.c3p0.ComboPooledDataSource;

/**
 * C3PO Connection Pooling implementation for stand-alone use, outside of a J2EE container 
 *
 */
public class StandaloneConnectionManager implements ConnectionManager
{

    private static StandaloneConnectionManager instance = null;

    protected ComboPooledDataSource pooledDS = null;

    private static Logger _logger = Logger.getLogger(StandaloneConnectionManager.class);

    // Why is this part of the interface??
    public synchronized ConnectionManager getInstance ()
    {
        if (null != instance) 
            return instance;
        
        try
        {
            instance = new StandaloneConnectionManager();
            instance.init();
        }
        catch (Exception e)
        {
            _logger.error("Could not initialise instance.", e);
            
            return null;
        }

        return instance;
    }

    public void init () throws ConfigurationException
    {
        _logger.info("initializing...");
        pooledDS = new ComboPooledDataSource();

        try
        {
            pooledDS.setDriverClass(Configuration.getStoreDriver());
            pooledDS.setJdbcUrl(Configuration.getStoreUrl());
            pooledDS.setUser(Configuration.getStoreUser());
            String password =  Configuration.getStorePwd();
            if (PasswordUtil.isPasswordFile(password))
            {
                password = new PasswordUtil(password).getPasswordAsString();
            }
            pooledDS.setPassword(password);
            pooledDS.setMinPoolSize(Integer.valueOf(Configuration
                    .getStorePoolMinSize()));
            pooledDS.setInitialPoolSize(Integer.valueOf(Configuration
                    .getStorePoolInitialSize()));
            pooledDS.setMaxPoolSize(Integer.valueOf(Configuration
                    .getStorePoolMaxSize()));
            pooledDS.setAutomaticTestTable(Configuration.getStorePoolTestTable());
            pooledDS.setCheckoutTimeout(Integer.valueOf(Configuration
                    .getStorePoolTimeoutMillis()));
        }
        catch (Exception ex)
        {
            throw new ConfigurationException(ex);
        }
    }

    public Connection getConnection () throws SQLException
    {
        Connection conn = null;

        // TODO: figure out why this is neccessary - pool should never return
        // null if DB is up and can connect
        // testing showed null was being returned from pool in QA test
        // MessageStoreTest
        
        while (true)
        {
            if (null != pooledDS)
            {
                if (null != (conn = pooledDS.getConnection())) 
                    break;
                else
                    _logger.error("Null pooledDS");
            }
            
            try
            {
                // TODO magic number
                
                Thread.sleep(1000);
            }
            catch (Exception e)
            {
            }
        }

        return conn;
    }

}
