/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2010
 */
package org.jboss.internal.soa.esb.message.filter;

import java.util.Date;
import java.util.Map;

import org.jboss.soa.esb.common.Environment;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.filter.InputOutputFilter;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.Properties;

/**
 * Adds the {@link Environment.MESSAGE_ENTRY_TIME} and {@link Environment.MESSAGE_EXIT_TIME} to the
 * {@link Properties} of the {@link Message}.<p/>
 * 
 * <i>Note: This functionality has been pulled out of {@link MetaDataFilter}.</i>
 * 
 * @author dward at jboss.org
 */
public class EntryExitTimeFilter extends InputOutputFilter
{
	
	@Override
	public Message onOutput(Message msg, Map<String, Object> params) throws CourierException
	{
		msg.getProperties().setProperty(Environment.MESSAGE_ENTRY_TIME, new Date().toString());
		return msg;
	}
	
	@Override
	public Message onInput(Message msg, Map<String, Object> params) throws CourierException
	{
		msg.getProperties().setProperty(Environment.MESSAGE_EXIT_TIME, new Date().toString());
		return msg;
	}
	
}
