/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.internal.soa.esb.listeners.war;

import java.util.ArrayList;
import java.util.List;

import org.jboss.soa.esb.Service;

/**
 * Servlet configuration model.
 * 
 * @author <a href="mailto:tom.fennelly@jboss.com">tom.fennelly@jboss.com</a>
 */
public class Servlet extends AbstractWebComponent {
	
	public static final String ENDPOINT_ADDRESS = "endpointAddress";

	private Integer loadOnStartup = null;
    private List<String> urlMappings = new ArrayList<String>();
    private SecurityConstraints securityConstraints;
    private Service service = null;
    private String endpointAddress = null;

    public Servlet(String name, String runtimeClass, WebModel webModel) {
        super(name, runtimeClass, webModel);
        webModel.getServlets().add(this);
    }
    
    public Integer getLoadOnStartup() {
    	return loadOnStartup;
    }
    
    public void setLoadOnStartup(Integer loadOnStartup) {
    	this.loadOnStartup = loadOnStartup;
    }

    public List<String> getUrlMappings() {
        return urlMappings;
    }

    public SecurityConstraints getSecurityConstraints() {
        return securityConstraints;
    }

    protected void setSecurityConstraints(SecurityConstraints securityConstraints) {
        this.securityConstraints = securityConstraints;
    }
    
    public Service getService() {
    	return service;
    }
    
    public void setService(Service service) {
    	this.service = service;
    }
    
    public String getEndpointAddress() {
    	return endpointAddress;
    }
    
    public void setEndpointAddress(String endpointAddress) {
    	this.endpointAddress = endpointAddress;
    }
    
}
