/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 */

package org.jboss.internal.soa.esb.addressing.eprs;

import java.net.URISyntaxException;
import java.util.UUID;

import org.jboss.soa.esb.addressing.eprs.JMSEpr;
import org.jboss.soa.esb.util.Util;

public class DefaultJmsReplyToEpr extends JMSEpr{

	public static final String REPLY_UUID_TAG = "jbossESBresponseUUID";

	public DefaultJmsReplyToEpr(JMSEpr epr)
		throws URISyntaxException
	{
		super(	epr.getVersion()
				,epr.getDestinationType()
				,replyDestinationName(epr)
				,epr.getConnectionFactory()
				,epr.getJndiEnvironment()
				,replySelector(epr)
				,epr.getPersistent()
			 );
	}
	private static String replyDestinationName(JMSEpr toEpr)
		throws URISyntaxException
	{
		return toEpr.getDestinationName()+JMSEpr.DEFAULT_REPLY_TO_DESTINATION_SUFFIX;
	}
	
	/**
	 * Unique reply message selector
	 * 
	 * @return String - the generated unique reply selector.
	 */
	@SuppressWarnings("unused")
    private static String replySelector(JMSEpr epr)
		throws URISyntaxException
	{
		StringBuilder sb = new StringBuilder();
		
		String oldSelector = epr.getMessageSelector();
		// If there was a message selector, use it
		if (!Util.isNullString(oldSelector))
			sb.append(oldSelector).append(" AND ");
		// And add a unique reply UUID
		sb.append(REPLY_UUID_TAG)
		  .append("='").append(UUID.randomUUID().toString()).append("'");
		return sb.toString();
	}

}
