package org.jboss.soa.esb.samples.quickstart.xml2swift;

import java.io.CharArrayWriter;

import net.sourceforge.wife.swift.model.SwiftMessage;
import net.sourceforge.wife.swift.parser.XMLParser;
import net.sourceforge.wife.swift.writer.SwiftWriter;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.AbstractActionLifecycle;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;

import org.jboss.soa.esb.message.Message;

public class XML2SwiftAction extends AbstractActionLifecycle {

	public XML2SwiftAction(ConfigTree config) throws ConfigurationException {
		
	}

	public Message process(Message msg) throws ActionProcessingException {
        String text =new String( (byte[])msg.getBody().get()); 
        
		SwiftWriter writer = new SwiftWriter();
		CharArrayWriter ch = new CharArrayWriter();
		XMLParser xmlParser = new XMLParser();
		SwiftMessage swiftMsg = xmlParser.parse(text);
		writer.writeMessage(swiftMsg, ch);
		msg.getBody().add(ch.toString());
		return msg;
	}
	
}
