/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated 
 * by the @authors tag. All rights reserved. 
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors. 
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 * 
 * (C) 2005-2006,
 * @author JBoss Inc.
 */
package org.jboss.soa.esb.samples.quickstart.wsmq;

import org.jboss.soa.esb.actions.AbstractActionLifecycle;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.message.Message;

import com.ibm.mq.jms.JMSC;
import com.ibm.mq.jms.MQQueueConnectionFactory;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.Connection;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Queue;
import javax.jms.MessageProducer;
import javax.jms.TextMessage;

public class WSMQRouterAction extends AbstractActionLifecycle
{
   protected ConfigTree _config;
   private QueueConnection conn;
   private String queueName;

   public WSMQRouterAction(ConfigTree config) throws Exception
   {
	   //TODO change to use JNDI !
      _config = config;
	  MQQueueConnectionFactory factory = new MQQueueConnectionFactory();
	  factory.setTransportType(JMSC.MQJMS_TP_CLIENT_MQ_TCPIP);
	  factory.setHostName(config.getAttribute("hostName"));
	  queueName = config.getAttribute("queueName");
	  factory.setChannel(config.getAttribute("channel"));
	  factory.setPort(Integer.parseInt(config.getAttribute("port")));
	  conn = factory.createQueueConnection(config.getAttribute("user"), config.getAttribute("password"));
      conn.start();
   }

   public Message noOperation(Message message)
   {
      return message;
   }

   /*
    * Retrieve and output the webservice response.
    */
   public Message process(Message message) throws Exception
   {
		QueueSession sess = conn.createQueueSession(false, Session.AUTO_ACKNOWLEDGE);
		
		Queue reply = sess.createQueue(queueName);

		QueueSender sender = sess.createSender(reply);
		Object body = message.getBody().get();
		if (body instanceof String) {
			TextMessage jmsMsg = sess.createTextMessage();
			jmsMsg.setText((String)body);
			sender.send(jmsMsg);
		} else {
			BytesMessage jmsMsg = sess.createBytesMessage();
			jmsMsg.writeBytes((byte[])body);
			sender.send(jmsMsg);
		}
		sender.close();
		sess.close();
      return message;
   }

}