/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.tools;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.axis1.Axis1XWSDL2JavaAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.axis2.Axis2WSDL2CodeAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.dotnet.DotNetWsdlAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.gsoap.GSoapAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.jaxb.JaxbXjcAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.jbossws.JBossWSConsumeAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.jbossws.WSToolsWsdl2JavaAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.oracle.OracleWsaGenProxyAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.AbstractToolsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.RunnerContext;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolRunner;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.wscompile.WSCompileAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.wsi.WSIAnalyzeAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.wsimport.WSImportAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.xfire.XFireAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.xmlbeans.XmlBeans2Action;
import com.eviware.soapui.model.iface.Interface;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;

public class SoapUIToolRunner
implements ToolHost,
RunnerContext {
    private static final Logger log = Logger.getLogger(SoapUIToolRunner.class);
    private String projectFile;
    private String iface;
    private String tool;
    private RunnerContext.RunnerStatus status;
    public static String TITLE = "soapUI 1.7.1 Tool Runner";

    public static void main(String[] args) throws Exception {
        System.out.println(TITLE);
        SoapUI.initSoapUILog();
        SoapUIToolRunner runner = new SoapUIToolRunner();
        Options options = new Options();
        options.addOption("i", true, "Sets the interface");
        options.addOption("t", true, "Sets the tool to run");
        options.addOption("s", false, "Sets the soapui-settings.xml file to use");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        String[] args2 = cmd.getArgs();
        if (args2.length != 1 || !cmd.hasOption("t")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("toolrunner [options] <soapui-project-file>", options);
            System.err.println("Missing soapUI project file..");
            return;
        }
        runner.setProjectFile(args2[0]);
        runner.setTool(cmd.getOptionValue("t"));
        if (cmd.hasOption("i")) {
            runner.setInterface(cmd.getOptionValue("i"));
        }
        if (cmd.hasOption("s")) {
            SoapUI.initSettings(cmd.getOptionValue("s"));
        }
        try {
            SoapUI.loadExtLibs();
            runner.run();
            System.exit(0);
        }
        catch (Exception e) {
            log.error((Object)e.toString());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void setProjectFile(String projectFile) {
        this.projectFile = projectFile;
    }

    public void setTool(String tool) {
        this.tool = tool;
    }

    public void setInterface(String iface) {
        this.iface = iface;
    }

    public void run() throws Exception {
        if (!new File(this.projectFile).exists()) {
            throw new Exception("soapUI project file [" + this.projectFile + "] not found");
        }
        WsdlProject project = new WsdlProject(this.projectFile, null);
        log.info((Object)("Running tools [" + this.tool + "] for interface [" + this.iface + "] in project [" + project.getName() + "]"));
        long startTime = System.nanoTime();
        for (int c = 0; c < project.getInterfaceCount(); ++c) {
            WsdlInterface i = project.getInterfaceAt(c);
            if (this.iface != null && !i.getName().equals(this.iface)) continue;
            this.runTool(i);
        }
        long timeTaken = (System.nanoTime() - startTime) / 1000000L;
        log.info((Object)("time taken: " + timeTaken + "ms"));
    }

    public void runTool(Interface iface) {
        String[] tools;
        AbstractToolsAction action = null;
        for (String tool : tools = this.tool.split(",")) {
            if (tool == null || tool.trim().length() == 0) continue;
            if (tool.equals("axis1")) {
                action = new Axis1XWSDL2JavaAction(iface);
            } else if (tool.equals("axis2")) {
                action = new Axis2WSDL2CodeAction(iface);
            } else if (tool.equals("dotnet")) {
                action = new DotNetWsdlAction(iface);
            } else if (tool.equals("gsoap")) {
                action = new GSoapAction(iface);
            } else if (tool.equals("jaxb")) {
                action = new JaxbXjcAction(iface);
            } else if (tool.equals("wstools")) {
                action = new WSToolsWsdl2JavaAction(iface);
            } else if (tool.equals("wscompile")) {
                action = new WSCompileAction(iface);
            } else if (tool.equals("wsimport")) {
                action = new WSImportAction(iface);
            } else if (tool.equals("wsconsume")) {
                action = new JBossWSConsumeAction(iface);
            } else if (tool.equals("xfire")) {
                action = new XFireAction(iface);
            } else if (tool.equals("xmlbeans")) {
                action = new XmlBeans2Action(iface);
            } else if (tool.equals("ora")) {
                action = new OracleWsaGenProxyAction(iface);
            } else if (tool.equals("wsi")) {
                action = new WSIAnalyzeAction(iface);
            }
            try {
                log.info((Object)("Running tool [" + action.getValue("Name") + "] for Interface [" + iface.getName() + "]"));
                action.run(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void run(ToolRunner runner) throws Exception {
        this.status = RunnerContext.RunnerStatus.RUNNING;
        runner.setContext(this);
        runner.run();
    }

    public RunnerContext.RunnerStatus getStatus() {
        return this.status;
    }

    public String getTitle() {
        return this.getClass().getSimpleName();
    }

    public void log(String msg) {
        System.out.print(msg);
    }

    public void logError(String msg) {
        System.err.println(msg);
    }

    public void setStatus(RunnerContext.RunnerStatus status) {
        this.status = status;
    }

    public void disposeContext() {
    }
}

