/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.types;

import com.eviware.soapui.config.StringToStringMapConfig;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringToStringMap
extends HashMap<String, String> {
    public StringToStringMap() {
    }

    public StringToStringMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public StringToStringMap(int initialCapacity) {
        super(initialCapacity);
    }

    public StringToStringMap(Map<? extends String, ? extends String> m) {
        super(m);
    }

    public String get(String key, String defaultValue) {
        String value = (String)this.get(key);
        return value == null ? defaultValue : value;
    }

    public String toXml() {
        StringToStringMapConfig xmlConfig = StringToStringMapConfig.Factory.newInstance();
        for (String key : this.keySet()) {
            StringToStringMapConfig.Entry entry = xmlConfig.addNewEntry();
            entry.setKey(key);
            entry.setValue((String)this.get(key));
        }
        return xmlConfig.toString();
    }

    public static StringToStringMap fromXml(String value) {
        StringToStringMap result = new StringToStringMap();
        if (value == null || value.trim().length() == 0) {
            return result;
        }
        try {
            StringToStringMapConfig nsMapping = StringToStringMapConfig.Factory.parse((String)value);
            for (StringToStringMapConfig.Entry entry : nsMapping.getEntryList()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public final boolean getBoolean(String key) {
        return Boolean.parseBoolean((String)this.get(key));
    }

    public boolean hasValue(String key) {
        return this.containsKey(key) && ((String)this.get(key)).length() > 0;
    }

    public void putIfMissing(String key, String value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
        }
    }

    @Override
    public void put(String key, boolean value) {
        this.put(key, Boolean.toString(value));
    }

    public static StringToStringMap fromHttpHeader(String value) {
        StringToStringMap result = new StringToStringMap();
        int ix = value.indexOf(59);
        while (ix > 0) {
            StringToStringMap.extractNVPair(value.substring(0, ix), result);
            value = value.substring(ix + 1);
            ix = value.indexOf(59);
        }
        if (value.length() > 2) {
            StringToStringMap.extractNVPair(value, result);
        }
        return result;
    }

    private static void extractNVPair(String value, StringToStringMap result) {
        int ix = value.indexOf(61);
        if (ix != -1) {
            String str = value.substring(ix + 1).trim();
            if (str.startsWith("\"") && str.endsWith("\"")) {
                str = str.substring(1, str.length() - 1);
            }
            result.put(value.substring(0, ix).trim(), str);
        }
    }
}

