/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.report;

import com.eviware.soapui.junit.ErrorDocument;
import com.eviware.soapui.junit.FailureDocument;
import com.eviware.soapui.junit.Properties;
import com.eviware.soapui.junit.Property;
import com.eviware.soapui.junit.Testcase;
import com.eviware.soapui.junit.Testsuite;
import com.eviware.soapui.junit.TestsuiteDocument;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Set;
import org.apache.xmlbeans.XmlOptions;

public class JUnitReport {
    TestsuiteDocument testsuiteDoc;
    int noofTestCases;
    int noofFailures;
    int noofErrors;
    StringBuffer systemOut = new StringBuffer();
    StringBuffer systemErr = new StringBuffer();

    public JUnitReport() {
        this.testsuiteDoc = TestsuiteDocument.Factory.newInstance();
        Testsuite testsuite = this.testsuiteDoc.addNewTestsuite();
        Properties properties = testsuite.addNewProperties();
        this.setSystemProperties(properties);
    }

    public void setTotalTime(double time) {
        this.testsuiteDoc.getTestsuite().setTime(new BigDecimal(time));
    }

    public void setTestSuiteName(String name) {
        this.testsuiteDoc.getTestsuite().setName(name);
    }

    public void setNoofErrorsInTestSuite(int errors) {
        this.testsuiteDoc.getTestsuite().setErrors(errors);
    }

    public void setNoofFailuresInTestSuite(int failures) {
        this.testsuiteDoc.getTestsuite().setFailures(failures);
    }

    public void systemOut(String systemout) {
        this.systemOut.append(systemout);
    }

    public void systemErr(String systemerr) {
        this.systemErr.append(systemerr);
    }

    public void setSystemOut(String systemout) {
        this.testsuiteDoc.getTestsuite().setSystemOut(systemout);
    }

    public void setSystemErr(String systemerr) {
        this.testsuiteDoc.getTestsuite().setSystemErr(systemerr);
    }

    public Testcase addTestCase(String name, double time) {
        Testcase testcase = this.testsuiteDoc.getTestsuite().addNewTestcase();
        testcase.setName(name);
        testcase.setTime(time);
        ++this.noofTestCases;
        return testcase;
    }

    public Testcase addTestCaseWithFailure(String name, double time, String failure, String stacktrace) {
        Testcase testcase = this.testsuiteDoc.getTestsuite().addNewTestcase();
        testcase.setName(name);
        testcase.setTime(time);
        FailureDocument.Failure fail = testcase.addNewFailure();
        fail.setType(failure);
        fail.setStringValue(stacktrace);
        ++this.noofTestCases;
        ++this.noofFailures;
        return testcase;
    }

    public Testcase addTestCaseWithError(String name, double time, String error, String stacktrace) {
        Testcase testcase = this.testsuiteDoc.getTestsuite().addNewTestcase();
        testcase.setName(name);
        testcase.setTime(time);
        ErrorDocument.Error err = testcase.addNewError();
        err.setType(error);
        err.setStringValue(stacktrace);
        ++this.noofTestCases;
        ++this.noofErrors;
        return testcase;
    }

    private void setSystemProperties(Properties properties) {
        Set<Object> keys = System.getProperties().keySet();
        for (Object keyO : keys) {
            String key = keyO.toString();
            String value = System.getProperty(key);
            Property prop = properties.addNewProperty();
            prop.setName(key);
            prop.setValue(value);
        }
    }

    public String toString() {
        this.testsuiteDoc.getTestsuite().setTests(this.noofTestCases);
        this.testsuiteDoc.getTestsuite().setFailures(this.noofFailures);
        this.testsuiteDoc.getTestsuite().setErrors(this.noofErrors);
        HashMap<String, String> prefixes = new HashMap<String, String>();
        prefixes.put("", "http://eviware.com/soapui/junit");
        return this.testsuiteDoc.xmlText(new XmlOptions().setSaveOuter().setCharacterEncoding("utf-8").setUseDefaultNamespace().setSaveImplicitNamespaces(prefixes));
    }
}

