/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes;

import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.InterfaceListener;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.tree.AbstractModelItemTreeNode;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.nodes.OperationTreeNode;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceTreeNode
extends AbstractModelItemTreeNode<Interface> {
    private InternalInterfaceListener interfaceListener;
    private List<OperationTreeNode> operationNodes = new ArrayList<OperationTreeNode>();

    public InterfaceTreeNode(Interface iface, SoapUITreeModel treeModel) {
        super(iface, iface.getProject(), treeModel);
        this.interfaceListener = new InternalInterfaceListener();
        iface.addInterfaceListener(this.interfaceListener);
        for (int c = 0; c < iface.getOperationCount(); ++c) {
            this.operationNodes.add(new OperationTreeNode(iface.getOperationAt(c), this.getTreeModel()));
        }
        treeModel.mapModelItems(this.operationNodes);
    }

    @Override
    public void release() {
        super.release();
        this.getInterface().removeInterfaceListener(this.interfaceListener);
        for (OperationTreeNode treeNode : this.operationNodes) {
            treeNode.release();
        }
    }

    public Interface getInterface() {
        return (Interface)this.getModelItem();
    }

    @Override
    public int getChildCount() {
        return this.operationNodes.size();
    }

    @Override
    public int getIndexOfChild(Object child) {
        return this.operationNodes.indexOf(child);
    }

    @Override
    public SoapUITreeNode getChildNode(int index) {
        return this.operationNodes.get(index);
    }

    private class InternalInterfaceListener
    implements InterfaceListener {
        private InternalInterfaceListener() {
        }

        public void requestAdded(Request request) {
            OperationTreeNode operationTreeNode = (OperationTreeNode)InterfaceTreeNode.this.getTreeModel().getTreeNode(request.getOperation());
            if (operationTreeNode != null) {
                operationTreeNode.requestAdded(request);
            }
        }

        public void requestRemoved(Request request) {
            OperationTreeNode operationTreeNode = (OperationTreeNode)InterfaceTreeNode.this.getTreeModel().getTreeNode(request.getOperation());
            if (operationTreeNode != null) {
                operationTreeNode.requestRemoved(request);
            }
        }

        public void operationAdded(Operation operation) {
            OperationTreeNode operationTreeNode = new OperationTreeNode(operation, InterfaceTreeNode.this.getTreeModel());
            InterfaceTreeNode.this.operationNodes.add(operationTreeNode);
            InterfaceTreeNode.this.getTreeModel().notifyNodeInserted(operationTreeNode);
        }

        public void operationRemoved(Operation operation) {
            SoapUITreeNode treeNode = InterfaceTreeNode.this.getTreeModel().getTreeNode(operation);
            if (!InterfaceTreeNode.this.operationNodes.contains(treeNode)) {
                throw new RuntimeException("Removing unkown operation");
            }
            InterfaceTreeNode.this.getTreeModel().notifyNodeRemoved(treeNode);
            InterfaceTreeNode.this.operationNodes.remove(treeNode);
        }

        public void operationUpdated(Operation operation) {
        }
    }
}

