/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.actions;

import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class CreateRequestAction
extends AbstractAction {
    private final WsdlTestRequestStepResult result;

    public CreateRequestAction(WsdlTestStepResult result) {
        this.result = (WsdlTestRequestStepResult)result;
        this.putValue("SmallIcon", UISupport.createImageIcon("/create_request_from_result.gif"));
        this.putValue("ShortDescription", "Creates a new request from this result");
    }

    public void actionPerformed(ActionEvent e) {
        WsdlTestRequestStep step = (WsdlTestRequestStep)this.result.getTestStep();
        String name = UISupport.prompt("Specify name of request", "Create Request", "Result from " + step.getName());
        if (name != null) {
            WsdlOperation operation = step.getTestRequest().getOperation();
            WsdlRequest request = operation.addNewRequest(name);
            request.setRequestContent(this.result.getRequestContent());
            request.setDomain(this.result.getDomain());
            request.setEncoding(this.result.getEncoding());
            request.setEndpoint(this.result.getEndpoint());
            request.setPassword(this.result.getPassword());
            request.setUsername(this.result.getUsername());
            UISupport.showDesktopPanel(request);
        }
    }
}

