/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.actions;

import com.eviware.soapui.impl.wsdl.panels.support.assertions.Assertable;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.WsdlAssertionRegistry;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class AddAssertionAction
extends AbstractAction {
    private final Assertable assertable;

    public AddAssertionAction(Assertable assertable) {
        super("Add Assertion");
        this.assertable = assertable;
        this.putValue("ShortDescription", "Adds an assertion to this test assertable");
        this.putValue("SmallIcon", UISupport.createImageIcon("/addAssertion.gif"));
    }

    public void actionPerformed(ActionEvent e) {
        String[] assertions = WsdlAssertionRegistry.getInstance().getAvailableAssertionNames(this.assertable.getAssertionType());
        if (assertions == null || assertions.length == 0) {
            UISupport.showErrorMessage("No assertions available for this message");
            return;
        }
        String selection = UISupport.prompt("Select assertion to add", "Select Assertion", assertions);
        if (selection == null) {
            return;
        }
        WsdlMessageAssertion assertion = this.assertable.addAssertion(selection);
        if (assertion == null) {
            UISupport.showErrorMessage("Failed to add assertion");
            return;
        }
        if (assertion.isConfigurable()) {
            assertion.configure();
        }
    }
}

