/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.actions.CloneTestStepAction;
import com.eviware.soapui.model.support.DefaultTestStepProperty;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.support.ScriptingSupport;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionSupport;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class WsdlGroovyScriptTestStep
extends WsdlTestStep {
    private static final Logger logger = Logger.getLogger((String)"groovy.log");
    private String scriptText = "";
    private Object scriptResult;
    private ImageIcon failedIcon;
    private ImageIcon okIcon;
    private Binding binding;
    private GroovyShell shell;
    private Script script;

    public WsdlGroovyScriptTestStep(WsdlTestCase testCase, TestStepConfig config) {
        super(testCase, config, false);
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new CloneTestStepAction(this, "Groovy Script"));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/groovystep.html"));
        this.okIcon = UISupport.createImageIcon("/groovy_script.gif");
        this.setIcon(this.okIcon);
        this.failedIcon = UISupport.createImageIcon("/groovy_script_failed.gif");
        if (config.getConfig() == null) {
            this.saveScript(config);
        } else {
            this.readConfig(config);
        }
        this.addProperty(new DefaultTestStepProperty("result", true, new DefaultTestStepProperty.PropertyHandlerAdapter(){

            public String getValue() {
                return WsdlGroovyScriptTestStep.this.scriptResult == null ? null : WsdlGroovyScriptTestStep.this.scriptResult.toString();
            }
        }, this));
        this.binding = new Binding();
        this.shell = ScriptingSupport.createGroovyShell(this.binding);
    }

    public Logger getLogger() {
        SoapUI.ensureGroovyLog();
        return logger;
    }

    private void readConfig(TestStepConfig config) {
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(config.getConfig());
        this.scriptText = reader.readString("script", "");
    }

    private void saveScript(TestStepConfig config) {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("script", this.scriptText);
        config.setConfig(builder.finish());
    }

    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.readConfig(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestStepResult run(TestRunner testRunner, TestRunContext context) {
        WsdlTestStepResult result;
        block16: {
            TestMonitor testMonitor = SoapUI.getTestMonitor();
            boolean hasRunningLoadTest = testMonitor == null ? false : testMonitor.hasRunningLoadTest(this.getTestCase());
            SoapUI.ensureGroovyLog();
            result = new WsdlTestStepResult(this);
            Logger log = (Logger)context.getProperty("log");
            if (log == null) {
                log = logger;
            }
            try {
                TestRunner.Status testRunnerStatus;
                if (this.scriptText.trim().length() > 0) {
                    WsdlGroovyScriptTestStep wsdlGroovyScriptTestStep = this;
                    synchronized (wsdlGroovyScriptTestStep) {
                        this.binding.setVariable("context", (Object)context);
                        this.binding.setVariable("testRunner", (Object)testRunner);
                        this.binding.setVariable("log", (Object)log);
                        if (this.script == null) {
                            this.script = this.shell.parse(this.scriptText);
                            this.script.setBinding(this.binding);
                        }
                        result.setTimeStamp(System.currentTimeMillis());
                        result.startTimer();
                        this.scriptResult = this.script.run();
                        result.stopTimer();
                        if (this.scriptResult != null) {
                            result.addMessage("Script-result: " + this.scriptResult.toString());
                        }
                    }
                }
                if ((testRunnerStatus = testRunner.getStatus()) == TestRunner.Status.FAILED) {
                    result.setStatus(TestStepResult.TestStepStatus.FAILED);
                } else if (testRunnerStatus == TestRunner.Status.CANCELED) {
                    result.setStatus(TestStepResult.TestStepStatus.CANCELED);
                } else {
                    result.setStatus(TestStepResult.TestStepStatus.OK);
                }
                if (hasRunningLoadTest) break block16;
                this.setIcon(testRunner.getStatus() == TestRunner.Status.FAILED ? this.failedIcon : this.okIcon);
            }
            catch (Throwable e) {
                block17: {
                    try {
                        log.error((Object)e);
                        result.stopTimer();
                        result.addMessage(e.getMessage());
                        result.setError(e);
                        result.setStatus(TestStepResult.TestStepStatus.FAILED);
                        if (hasRunningLoadTest) break block17;
                        this.setIcon(testRunner.getStatus() == TestRunner.Status.FAILED ? this.failedIcon : this.okIcon);
                    }
                    catch (Throwable throwable) {
                        if (!hasRunningLoadTest) {
                            this.setIcon(testRunner.getStatus() == TestRunner.Status.FAILED ? this.failedIcon : this.okIcon);
                        }
                        this.binding.getVariables().clear();
                        throw throwable;
                    }
                }
                this.binding.getVariables().clear();
            }
        }
        this.binding.getVariables().clear();
        return result;
    }

    public String getScript() {
        return this.scriptText;
    }

    public void setScript(String scriptText) {
        if (scriptText.equals(this.scriptText)) {
            return;
        }
        this.scriptText = scriptText;
        this.script = null;
        this.saveScript((TestStepConfig)this.getConfig());
    }
}

