/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.config.TransferValuesStepConfig;
import com.eviware.soapui.config.ValueTransferConfig;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.PropertyTransfer;
import com.eviware.soapui.impl.wsdl.teststeps.PropertyTransferException;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.actions.CloneTestStepAction;
import com.eviware.soapui.impl.wsdl.teststeps.actions.ShowTransferValuesResultsAction;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.monitor.TestMonitor;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionSupport;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;

public class TransferResponseValuesTestStep
extends WsdlTestStep {
    private TransferValuesStepConfig transferStepConfig;
    private boolean canceled;
    private List<PropertyTransfer> transfers = new ArrayList<PropertyTransfer>();
    private ImageIcon failedIcon;
    private ImageIcon okIcon = UISupport.createImageIcon("/value_transfer.gif");

    public TransferResponseValuesTestStep(WsdlTestCase testCase, TestStepConfig config) {
        super(testCase, config, true);
        this.failedIcon = UISupport.createImageIcon("/value_transfer_failed.gif");
        this.setIcon(this.okIcon);
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new CloneTestStepAction(this, "PropertyTransfer"));
        this.addAction(ActionSupport.SEPARATOR_ACTION);
        this.addAction(new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/propertytransfers.html"));
        if (testCase == null) {
            this.postInit(config);
        }
    }

    public void postInit(TestStepConfig config) {
        if (config.getConfig() != null) {
            this.transferStepConfig = (TransferValuesStepConfig)config.getConfig().changeType(TransferValuesStepConfig.type);
            for (int c = 0; c < this.transferStepConfig.sizeOfTransfersArray(); ++c) {
                this.transfers.add(new PropertyTransfer(this, this.transferStepConfig.getTransfersArray(c)));
            }
        } else {
            this.transferStepConfig = (TransferValuesStepConfig)config.addNewConfig().changeType(TransferValuesStepConfig.type);
        }
    }

    public TransferValuesStepConfig getTransferConfig() {
        return this.transferStepConfig;
    }

    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.transferStepConfig = (TransferValuesStepConfig)config.getConfig().changeType(TransferValuesStepConfig.type);
        for (int c = 0; c < this.transferStepConfig.sizeOfTransfersArray(); ++c) {
            this.transfers.get(c).setConfigOnMove(this.transferStepConfig.getTransfersArray(c));
        }
    }

    public TestStepResult run(TestRunner runner, TestRunContext context) {
        TestMonitor testMonitor = SoapUI.getTestMonitor();
        boolean hasRunningLoadTest = testMonitor == null ? false : testMonitor.hasRunningLoadTest(this.getTestCase());
        ValueTransferResult result = new ValueTransferResult();
        result.addAction(new ShowTransferValuesResultsAction(result), true);
        this.canceled = false;
        long startTime = System.currentTimeMillis();
        for (int c = 0; c < this.transfers.size(); ++c) {
            PropertyTransfer valueTransfer = this.transfers.get(c);
            try {
                if (this.canceled) {
                    result.setStatus(TestStepResult.TestStepStatus.CANCELED);
                    result.setTimeTaken(System.currentTimeMillis() - startTime);
                    return result;
                }
                String[] values = valueTransfer.transferProperties(context);
                if (values == null || values.length <= 0) continue;
                String name = valueTransfer.getName();
                result.addMessage("Performed transfer [" + name + "]");
                result.addTransferResult(valueTransfer, values);
                continue;
            }
            catch (PropertyTransferException e) {
                result.addMessage("Error performing transfer [" + valueTransfer.getName() + "]");
                result.addTransferResult(valueTransfer, new String[]{e.toString()});
                if (!this.transfers.get(c).getFailOnError()) continue;
                result.setError(e);
                result.setStatus(TestStepResult.TestStepStatus.FAILED);
                result.setTimeTaken(System.currentTimeMillis() - startTime);
                if (!hasRunningLoadTest) {
                    this.setIcon(this.failedIcon);
                }
                return result;
            }
        }
        if (!hasRunningLoadTest) {
            this.setIcon(this.okIcon);
        }
        result.setStatus(TestStepResult.TestStepStatus.OK);
        result.setTimeTaken(System.currentTimeMillis() - startTime);
        return result;
    }

    public boolean cancel() {
        this.canceled = true;
        return this.canceled;
    }

    public int getTransferCount() {
        return this.transferStepConfig.sizeOfTransfersArray();
    }

    public PropertyTransfer getTransferAt(int index) {
        return this.transfers.get(index);
    }

    public PropertyTransfer addTransfer(String name) {
        PropertyTransfer transfer = new PropertyTransfer(this, this.transferStepConfig.addNewTransfers());
        transfer.setName(name);
        transfer.setFailOnError(true);
        this.transfers.add(transfer);
        return transfer;
    }

    public void removeTransferAt(int index) {
        this.transfers.remove(index).release();
        this.transferStepConfig.removeTransfers(index);
    }

    public TestStepResult createFailedResult(String message) {
        ValueTransferResult result = new ValueTransferResult();
        result.setStatus(TestStepResult.TestStepStatus.FAILED);
        result.addMessage(message);
        return result;
    }

    public void release() {
        super.release();
        for (PropertyTransfer transfer : this.transfers) {
            transfer.release();
        }
    }

    public PropertyTransfer getTransferByName(String name) {
        for (int c = 0; c < this.getTransferCount(); ++c) {
            PropertyTransfer transfer = this.getTransferAt(c);
            if (!transfer.getName().equals(name)) continue;
            return transfer;
        }
        return null;
    }

    public class ValueTransferResult
    extends WsdlTestStepResult {
        private List<ValueTransferConfig> transfers;
        private List<String[]> values;

        public ValueTransferResult() {
            super(TransferResponseValuesTestStep.this);
            this.transfers = new ArrayList<ValueTransferConfig>();
            this.values = new ArrayList<String[]>();
        }

        public void addTransferResult(PropertyTransfer transfer, String[] values) {
            this.transfers.add((ValueTransferConfig)transfer.getConfig().copy());
            this.values.add(values);
        }

        public int getTransferCount() {
            return this.transfers == null ? 0 : this.transfers.size();
        }

        public ValueTransferConfig getTransferAt(int index) {
            return this.transfers == null ? null : this.transfers.get(index);
        }

        public String[] getTransferredValuesAt(int index) {
            return this.values == null ? null : this.values.get(index);
        }

        public void discard() {
            super.discard();
            this.transfers = null;
            this.values = null;
        }

        public void writeTo(PrintWriter writer) {
            super.writeTo(writer);
            if (!this.isDiscarded()) {
                writer.println("----------------------------------------------------");
                for (int c = 0; c < this.transfers.size(); ++c) {
                    ValueTransferConfig transfer = this.transfers.get(c);
                    writer.println(transfer.getName() + " transferred [" + Arrays.toString(this.values.get(c)) + "] from [" + transfer.getSourceStep() + "." + transfer.getSourceType() + "] to [" + transfer.getTargetStep() + "." + transfer.getTargetType() + "]");
                    if (transfer.getSourcePath() != null) {
                        writer.println("------------ source path -------------");
                        writer.println(transfer.getSourcePath());
                    }
                    if (transfer.getTargetPath() == null) continue;
                    writer.println("------------ target path -------------");
                    writer.println(transfer.getTargetPath());
                }
            }
        }
    }
}

