/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.soap;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.support.soap.AbstractSoapVersion;
import java.io.IOException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.xmlsoap.schemas.soap.envelope.EnvelopeDocument;

public class SoapVersion11
extends AbstractSoapVersion {
    private static final QName envelopeQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
    private static final QName bodyQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body");
    private static final QName faultQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
    private static final QName headerQName = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Header");
    SchemaTypeLoader soapSchema;
    SchemaType soapEnvelopeType;
    private XmlObject soapSchemaXml;
    private XmlObject soapEncodingXml;
    private SchemaType soapFaultType;
    public static final SoapVersion11 instance = new SoapVersion11();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SoapVersion11() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SoapUI.class.getClassLoader());
        try {
            XmlOptions options = new XmlOptions();
            options.setCompileNoValidation();
            options.setCompileNoPvrRule();
            options.setCompileDownloadUrls();
            options.setCompileNoUpaRule();
            options.setValidateTreatLaxAsSkip();
            this.soapSchemaXml = XmlObject.Factory.parse((URL)SoapUI.class.getResource("/soapEnvelope.xsd"), (XmlOptions)options);
            this.soapSchema = XmlBeans.loadXsd((XmlObject[])new XmlObject[]{this.soapSchemaXml});
            this.soapEnvelopeType = this.soapSchema.findDocumentType(envelopeQName);
            this.soapFaultType = this.soapSchema.findDocumentType(faultQName);
            this.soapEncodingXml = XmlObject.Factory.parse((URL)SoapUI.class.getResource("/soapEncoding.xsd"), (XmlOptions)options);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public SchemaType getEnvelopeType() {
        return EnvelopeDocument.type;
    }

    public String getEnvelopeNamespace() {
        return "http://schemas.xmlsoap.org/soap/envelope/";
    }

    public String getEncodingNamespace() {
        return "http://schemas.xmlsoap.org/soap/encoding/";
    }

    public XmlObject getSoapEncodingSchema() throws XmlException, IOException {
        return this.soapEncodingXml;
    }

    public XmlObject getSoapEnvelopeSchema() throws XmlException, IOException {
        return this.soapSchemaXml;
    }

    public String toString() {
        return "SOAP 1.1";
    }

    public String getContentTypeHttpHeader(String encoding) {
        if (encoding == null || encoding.trim().length() == 0) {
            return this.getContentType();
        }
        return this.getContentType() + ";charset=" + encoding;
    }

    public String getContentType() {
        return "text/xml";
    }

    public QName getBodyQName() {
        return bodyQName;
    }

    public QName getEnvelopeQName() {
        return envelopeQName;
    }

    public QName getHeaderQName() {
        return headerQName;
    }

    protected SchemaTypeLoader getSoapEnvelopeSchemaLoader() {
        return this.soapSchema;
    }

    public SchemaType getFaultType() {
        return this.soapFaultType;
    }
}

