/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.RequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.PropertyExpansionRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.AttachmentUtils;
import com.eviware.soapui.impl.wsdl.submit.transports.http.BaseHttpRequestTransport;
import com.eviware.soapui.impl.wsdl.submit.transports.http.MimeMessageRequestEntity;
import com.eviware.soapui.impl.wsdl.submit.transports.http.MimeMessageResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SinglePartHttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.TimeablePostMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlRequestDataSource;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.support.MessageXmlObject;
import com.eviware.soapui.impl.wsdl.support.MessageXmlPart;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.types.StringToStringMap;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.PreencodedMimeBodyPart;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.log4j.Logger;

public class HttpClientRequestTransport
implements BaseHttpRequestTransport {
    private List<RequestFilter> filters = new ArrayList<RequestFilter>();
    private static final Logger log = Logger.getLogger(HttpClientRequestTransport.class);

    public void addRequestFilter(RequestFilter filter) {
        this.filters.add(filter);
    }

    public void removeRequestFilter(RequestFilter filter) {
        this.filters.remove(filter);
    }

    public void abortRequest(SubmitContext submitContext) {
        TimeablePostMethod postMethod = (TimeablePostMethod)((Object)submitContext.getProperty("postMethod"));
        postMethod.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response sendRequest(SubmitContext submitContext, WsdlRequest wsdlRequest) throws Exception {
        HttpClient httpClient = HttpClientSupport.getHttpClient();
        TimeablePostMethod postMethod = new TimeablePostMethod();
        boolean createdState = false;
        HttpState httpState = (HttpState)submitContext.getProperty("#HTTP_STATE");
        if (httpState == null) {
            httpState = new HttpState();
            submitContext.setProperty("#HTTP_STATE", httpState);
            createdState = true;
        }
        HostConfiguration hostConfiguration = new HostConfiguration();
        submitContext.setProperty("postMethod", (Object)postMethod);
        submitContext.setProperty("httpClient", httpClient);
        submitContext.setProperty("requestContent", wsdlRequest.getRequestContent());
        submitContext.setProperty("hostConfiguration", hostConfiguration);
        submitContext.setProperty("wsdlRequest", wsdlRequest);
        for (RequestFilter filter : this.filters) {
            filter.filterRequest(submitContext, wsdlRequest);
        }
        try {
            WsdlResponse wsdlResponse;
            Settings settings = wsdlRequest.getSettings();
            String requestContent = (String)submitContext.getProperty("requestContent");
            requestContent = this.initRequest(wsdlRequest, postMethod, requestContent);
            if (settings.getBoolean(HttpSettings.INCLUDE_REQUEST_IN_TIME_TAKEN)) {
                postMethod.initStartTime();
            }
            StringToStringMap headers = wsdlRequest.getRequestHeaders();
            for (String header : headers.keySet()) {
                String headerValue = (String)headers.get(header);
                headerValue = PropertyExpansionRequestFilter.expandProperties(submitContext, headerValue);
                postMethod.setRequestHeader(header, headerValue);
            }
            httpClient.executeMethod(hostConfiguration, (HttpMethod)postMethod, httpState);
            Header responseContentTypeHeader = postMethod.getResponseHeader("Content-Type");
            if (!settings.getBoolean(WsdlRequest.INLINE_RESPONSE_ATTACHMENTS) && responseContentTypeHeader != null && responseContentTypeHeader.getValue().toUpperCase().startsWith("MULTIPART")) {
                wsdlResponse = new MimeMessageResponse(wsdlRequest, postMethod, requestContent);
                return wsdlResponse;
            }
            wsdlResponse = new SinglePartHttpResponse(wsdlRequest, postMethod, requestContent);
            return wsdlResponse;
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            } else {
                log.error((Object)"PostMethod is null");
            }
            if (createdState) {
                submitContext.setProperty("#HTTP_STATE", null);
            }
        }
    }

    private String initRequest(WsdlRequest wsdlRequest, TimeablePostMethod postMethod, String requestContent) throws Exception {
        MimeMultipart mp = null;
        StringToStringMap contentIds = new StringToStringMap();
        boolean isXOP = false;
        if (wsdlRequest.isMtomEnabled() || wsdlRequest.getAttachmentCount() > 0) {
            try {
                MessageXmlPart[] requestParts;
                mp = new MimeMultipart();
                MessageXmlObject requestXmlObject = new MessageXmlObject(wsdlRequest.getOperation(), requestContent, true);
                for (MessageXmlPart requestPart : requestParts = requestXmlObject.getMessageParts()) {
                    if (!AttachmentUtils.prepareMessagePart(wsdlRequest, mp, requestPart, contentIds)) continue;
                    isXOP = true;
                }
                requestContent = requestXmlObject.getMessageContent();
            }
            catch (Exception e) {
                log.warn((Object)("Failed to process inline/MTOM attachments; " + e));
            }
        }
        if (!(isXOP || mp != null && mp.getCount() != 0 || wsdlRequest.getAttachmentCount() != 0)) {
            String encoding = StringUtils.unquote(wsdlRequest.getEncoding());
            byte[] content = encoding == null ? requestContent.getBytes() : requestContent.getBytes(encoding);
            postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(content));
        } else {
            if (mp == null) {
                mp = new MimeMultipart();
            }
            this.initRootPart(wsdlRequest, requestContent, mp, isXOP);
            AttachmentUtils.addMimeParts(wsdlRequest, mp, contentIds);
            MimeMessage message = new MimeMessage(AttachmentUtils.JAVAMAIL_SESSION);
            message.setContent((Multipart)mp);
            message.saveChanges();
            MimeMessageRequestEntity mimeMessageRequestEntity = new MimeMessageRequestEntity(message, isXOP, wsdlRequest);
            postMethod.setRequestEntity(mimeMessageRequestEntity);
            postMethod.setRequestHeader("Content-Type", mimeMessageRequestEntity.getContentType());
            postMethod.setRequestHeader("MIME-Version", "1.0");
        }
        return requestContent;
    }

    private void initRootPart(WsdlRequest wsdlRequest, String requestContent, MimeMultipart mp, boolean isXOP) throws MessagingException {
        PreencodedMimeBodyPart rootPart = new PreencodedMimeBodyPart("8bit");
        rootPart.setContentID("<rootpart@soapui.org>");
        mp.addBodyPart((BodyPart)rootPart, 0);
        DataHandler dataHandler = new DataHandler((DataSource)new WsdlRequestDataSource(wsdlRequest, requestContent, isXOP));
        rootPart.setDataHandler(dataHandler);
    }
}

