/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import java.io.IOException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.NTLMScheme;
import org.apache.commons.httpclient.auth.RFC2617Scheme;
import org.apache.log4j.Logger;

public final class WsdlRequestCredentialsProvider
implements CredentialsProvider {
    private boolean checkedCredentials;
    private final WsdlRequest wsdlRequest;
    private static final Logger logger = Logger.getLogger(WsdlRequestCredentialsProvider.class);

    public WsdlRequestCredentialsProvider(WsdlRequest wsdlRequest) {
        this.wsdlRequest = wsdlRequest;
    }

    public Credentials getCredentials(AuthScheme authscheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
        if (this.checkedCredentials) {
            throw new CredentialsNotAvailableException("Missing valid credentials");
        }
        if (authscheme == null) {
            return null;
        }
        try {
            if (authscheme instanceof NTLMScheme) {
                logger.info((Object)(host + ":" + port + " requires Windows authentication"));
                NTCredentials nTCredentials = new NTCredentials(this.wsdlRequest.getUsername(), this.wsdlRequest.getPassword(), host, this.wsdlRequest.getDomain());
                return nTCredentials;
            }
            if (authscheme instanceof RFC2617Scheme) {
                logger.info((Object)(host + ":" + port + " requires authentication with the realm '" + authscheme.getRealm() + "'"));
                UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.wsdlRequest.getUsername(), this.wsdlRequest.getPassword());
                return usernamePasswordCredentials;
            }
            try {
                throw new CredentialsNotAvailableException("Unsupported authentication scheme: " + authscheme.getSchemeName());
            }
            catch (IOException e) {
                throw new CredentialsNotAvailableException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            this.checkedCredentials = true;
        }
    }
}

