/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.filters;

import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.submit.RequestFilter;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.support.xml.XmlUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class PropertyExpansionRequestFilter
implements RequestFilter {
    private static final char PROPERTY_SEPARATOR = '#';
    private static final Logger log = Logger.getLogger(PropertyExpansionRequestFilter.class);

    public void filterRequest(SubmitContext context, WsdlRequest wsdlRequest) {
        String content = (String)context.getProperty("requestContent");
        if (content == null) {
            log.warn((Object)"Missing request content in context, skipping property expansion");
        } else if ((content = PropertyExpansionRequestFilter.expandProperties(context, content)) != null) {
            context.setProperty("requestContent", content);
        }
    }

    public static String expandProperties(SubmitContext context, String content) {
        int ix = content.indexOf("${");
        if (ix == -1) {
            return content;
        }
        StringBuffer buf = new StringBuffer();
        int lastIx = 0;
        while (ix != -1) {
            int sepIx;
            String propertyName;
            Object property;
            buf.append(content.substring(lastIx, ix));
            int ix2 = content.indexOf(125, ix + 2);
            if (ix2 == -1) break;
            int ix3 = content.lastIndexOf("${", ix2);
            if (ix3 != ix) {
                buf.append(content.substring(ix, ix3));
                ix = ix3;
            }
            if ((property = context.getProperty(propertyName = content.substring(ix + 2, ix2))) != null) {
                buf.append(property.toString());
            } else if (context instanceof TestRunContext) {
                sepIx = propertyName.indexOf(35);
                if (sepIx > 0) {
                    String step = propertyName.substring(0, sepIx);
                    String name = propertyName.substring(sepIx + 1);
                    if ((sepIx = name.indexOf(35)) != -1) {
                        String xpath = name.substring(sepIx + 1);
                        name = name.substring(0, sepIx);
                        property = step.length() == 0 ? ((TestRunContext)context).getProperty(name) : ((TestRunContext)context).getProperty(step, name);
                        if (property != null) {
                            property = PropertyExpansionRequestFilter.extractXPathPropertyValue(property, xpath);
                        }
                    } else {
                        property = step.length() == 0 ? ((TestRunContext)context).getProperty(name) : ((TestRunContext)context).getProperty(step, name);
                    }
                    if (property != null) {
                        buf.append(property.toString());
                    }
                }
            } else if (propertyName.charAt(0) == '#') {
                sepIx = propertyName.indexOf(35, 1);
                if (sepIx > 0) {
                    String xpath = propertyName.substring(sepIx + 1);
                    property = context.getProperty(propertyName = propertyName.substring(1, sepIx));
                    if (property != null) {
                        property = PropertyExpansionRequestFilter.extractXPathPropertyValue(property, xpath);
                    }
                } else {
                    property = context.getProperty(propertyName.substring(1));
                }
                if (property != null) {
                    buf.append(property.toString());
                }
            }
            if (property == null) {
                if (log.isEnabledFor(Priority.WARN)) {
                    log.warn((Object)("Missing property value for [" + propertyName + "]"));
                }
                buf.append("${").append(propertyName).append('}');
            }
            lastIx = ix2 + 1;
            ix = content.indexOf("${", lastIx);
        }
        if (lastIx < content.length()) {
            buf.append(content.substring(lastIx));
        }
        return buf.toString();
    }

    public static String extractXPathPropertyValue(Object property, String xpath) {
        try {
            XmlObject xmlObject = XmlObject.Factory.parse((String)property.toString());
            String ns = XmlUtils.declareXPathNamespaces(xmlObject);
            XmlObject[] paths = xmlObject.selectPath(ns + xpath);
            if (paths.length > 0) {
                return XmlUtils.getNodeValue(paths[0].getDomNode());
            }
        }
        catch (XmlException e) {
            e.printStackTrace();
        }
        return null;
    }
}

