/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit;

import com.eviware.soapui.impl.wsdl.submit.RequestTransport;
import com.eviware.soapui.impl.wsdl.submit.filters.HttpAuthenticationRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.HttpProxyRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.HttpSettingsRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.PropertyExpansionRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.SoapHeadersRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.StripWhitespacesRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.filters.WsSecurityAuthenticationRequestFilter;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpClientRequestTransport;
import com.eviware.soapui.model.iface.SubmitContext;
import java.util.HashMap;
import java.util.Map;

public class RequestTransportRegistry {
    public static final String HTTP = "http";
    public static final String HTTPS = "https";
    private static Map<String, RequestTransport> transports = new HashMap<String, RequestTransport>();

    public static RequestTransport getTransport(String endpoint, SubmitContext submitContext) throws MissingTransportException {
        int ix = endpoint.indexOf("://");
        if (ix == -1) {
            throw new MissingTransportException("Missing protocol in endpoint [" + endpoint + "]");
        }
        String protocol = endpoint.substring(0, ix).toLowerCase();
        RequestTransport transport = transports.get(protocol);
        if (transport == null) {
            throw new MissingTransportException("Missing transport for protocol [" + protocol + "]");
        }
        return transport;
    }

    static {
        HttpClientRequestTransport httpTransport = new HttpClientRequestTransport();
        httpTransport.addRequestFilter(new HttpSettingsRequestFilter());
        httpTransport.addRequestFilter(new SoapHeadersRequestFilter());
        httpTransport.addRequestFilter(new HttpProxyRequestFilter());
        httpTransport.addRequestFilter(new HttpAuthenticationRequestFilter());
        httpTransport.addRequestFilter(new WsSecurityAuthenticationRequestFilter());
        httpTransport.addRequestFilter(new PropertyExpansionRequestFilter());
        httpTransport.addRequestFilter(new StripWhitespacesRequestFilter());
        transports.put(HTTP, httpTransport);
        transports.put(HTTPS, httpTransport);
    }

    public static class MissingTransportException
    extends Exception {
        public MissingTransportException(String msg) {
            super(msg);
        }
    }
}

