/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.request.components.editor.support;

import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlDocument;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlEditor;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlEditorView;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlLocation;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlLocationListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractEditorView
implements XmlEditorView,
PropertyChangeListener {
    private String title;
    private boolean isActive;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private XmlDocument xmlDocument;
    private boolean xmlChanged;
    private Set<XmlLocationListener> listeners = new HashSet<XmlLocationListener>();
    private XmlEditor editor;

    public AbstractEditorView(String title) {
        this.title = title;
        this.xmlChanged = true;
    }

    public boolean activate(XmlLocation location) {
        this.isActive = true;
        if (this.xmlChanged) {
            this.setXml(this.xmlDocument == null ? null : this.xmlDocument.getXml());
        }
        return true;
    }

    public boolean deactivate() {
        this.isActive = false;
        this.xmlChanged = false;
        return true;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String oldTitle = this.title;
        this.title = title;
        this.propertyChangeSupport.firePropertyChange(TITLE_PROPERTY, oldTitle, title);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public XmlDocument getXmlDocument() {
        return this.xmlDocument;
    }

    public void setXmlDocument(XmlDocument xmlDocument) {
        if (this.xmlDocument != null) {
            this.xmlDocument.removePropertyChangeListener(XmlDocument.XML_PROPERTY, this);
        }
        this.xmlDocument = xmlDocument;
        if (xmlDocument != null) {
            this.xmlDocument.addPropertyChangeListener(XmlDocument.XML_PROPERTY, this);
            this.setXml(xmlDocument.getXml());
        } else {
            this.setXml(null);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.isActive()) {
            this.setXml((String)evt.getNewValue());
        } else {
            this.xmlChanged = true;
        }
    }

    protected abstract void setXml(String var1);

    public void release() {
        if (this.xmlDocument != null) {
            this.xmlDocument.removePropertyChangeListener(XmlDocument.XML_PROPERTY, this);
        }
    }

    public void addLocationListener(XmlLocationListener listener) {
        this.listeners.add(listener);
    }

    public void removeLocationListener(XmlLocationListener listener) {
        this.listeners.remove(listener);
    }

    public void fireLocationChanged(XmlLocation location) {
        for (XmlLocationListener listener : this.listeners) {
            listener.locationChanged(location);
        }
    }

    public XmlLocation getLocation() {
        return null;
    }

    public void setLocation(XmlLocation location) {
    }

    public void locationChanged(XmlLocation location) {
    }

    public void init(XmlEditor editor) {
        this.editor = editor;
    }

    public XmlEditor getEditor() {
        return this.editor;
    }

    public void requestFocus() {
    }
}

