/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.attachments;

import com.eviware.soapui.impl.wsdl.WsdlAttachmentPart;
import com.eviware.soapui.impl.wsdl.WsdlRequest;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.panels.attachments.FileTransferHandler;
import com.eviware.soapui.impl.wsdl.panels.attachments.MockAttachmentTableModel;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MockAttachmentPanel
extends JPanel {
    private DropTarget dropTarget;
    private FileTransferHandler fileTransferHandler;
    private MockAttachmentTableModel tableModel;
    private JFileChooser fc;
    private final WsdlMockResponse mockOperation;
    boolean allowChange = false;
    boolean isResponse = false;
    private JButton exportBtn;
    private JButton addFileBtn;
    private JTable fileTable;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JButton removeBtn;
    private AttachmentPartCellEditor attachmentPartCellEditor;

    public MockAttachmentPanel(WsdlMockResponse response, boolean isResponse) {
        this.mockOperation = response;
        this.allowChange = isResponse;
        this.isResponse = isResponse;
        this.initComponents();
        this.initFileTransfer();
    }

    public void release() {
        this.tableModel.release();
        if (this.attachmentPartCellEditor != null) {
            this.attachmentPartCellEditor.release();
        }
    }

    private void initFileTransfer() {
        if (this.allowChange) {
            this.fileTransferHandler = new FileTransferHandler(this.tableModel);
            this.fileTable.setDragEnabled(true);
            this.fileTable.setTransferHandler(this.fileTransferHandler);
            this.dropTarget = new DropTarget();
            this.dropTarget.setActive(true);
            try {
                this.dropTarget.addDropTargetListener(new DropTargetListener(){

                    public void dragEnter(DropTargetDragEvent dtde) {
                    }

                    public void dragExit(DropTargetEvent dte) {
                    }

                    public void dragOver(DropTargetDragEvent dtde) {
                    }

                    public void drop(DropTargetDropEvent dtde) {
                        try {
                            dtde.acceptDrop(3);
                            Transferable trans = dtde.getTransferable();
                            List files = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                            for (File f : files) {
                                System.out.println("Dropping file: " + f.getName());
                                Boolean retval = UISupport.confirmOrCancel("Cache attachment in response?", "Att Attachment");
                                if (retval == null) {
                                    return;
                                }
                                MockAttachmentPanel.this.tableModel.addFile(f, retval);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    public void dropActionChanged(DropTargetDragEvent dtde) {
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.jScrollPane1.getViewport().setDropTarget(this.dropTarget);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tableModel = new MockAttachmentTableModel(this.mockOperation, this.isResponse);
        this.fileTable = new JTable(this.tableModel);
        if (this.isResponse) {
            this.attachmentPartCellEditor = new AttachmentPartCellEditor();
            this.fileTable.getColumnModel().getColumn(3).setCellEditor(this.attachmentPartCellEditor);
        }
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.fileTable);
        this.add((Component)this.jScrollPane1, "Center");
        this.jPanel1 = new JPanel();
        if (this.allowChange) {
            this.addFileBtn = new JButton();
            this.removeBtn = new JButton();
            this.addFileBtn.setText("Add file");
            this.addFileBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MockAttachmentPanel.this.addFileBtnActionPerformed(evt);
                }
            });
            this.jPanel1.add(this.addFileBtn);
            this.removeBtn.setText("Remove selected");
            this.removeBtn.setEnabled(false);
            this.removeBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MockAttachmentPanel.this.removeBtnActionPerformed(evt);
                }
            });
            this.jPanel1.add(this.removeBtn);
        }
        this.exportBtn = new JButton();
        this.exportBtn.setText("Export selected");
        this.exportBtn.setEnabled(false);
        this.exportBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MockAttachmentPanel.this.exportBtnActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.exportBtn);
        this.jPanel1.add(new JButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/attachments.html")));
        this.add((Component)this.jPanel1, "South");
        this.fileTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (MockAttachmentPanel.this.removeBtn != null) {
                    MockAttachmentPanel.this.removeBtn.setEnabled(MockAttachmentPanel.this.fileTable.getSelectedRowCount() > 0);
                }
                MockAttachmentPanel.this.exportBtn.setEnabled(MockAttachmentPanel.this.fileTable.getSelectedRowCount() > 0);
            }
        });
        this.fileTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    return;
                }
                int ix = MockAttachmentPanel.this.fileTable.getSelectedRow();
                if (ix == -1) {
                    return;
                }
                Attachment attachment = MockAttachmentPanel.this.isResponse ? MockAttachmentPanel.this.mockOperation.getAttachments()[ix] : MockAttachmentPanel.this.mockOperation.getMockResult().getMockRequest().getRequestAttachments()[ix];
                String url = attachment.getUrl();
                if (url != null) {
                    Tools.openURL(url);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
    }

    protected void exportBtnActionPerformed(ActionEvent evt) {
        File file = UISupport.getFileDialogs().saveAs(this, "Export Attachment..");
        while (file != null && file.exists() && !UISupport.confirm("File " + file.getName() + " exists, overwrite?", "Export Attachment")) {
            file = UISupport.getFileDialogs().saveAs(this, "Export Attachment..");
        }
        if (file != null) {
            Attachment attachment = this.tableModel.getAttachmentAt(this.fileTable.getSelectedRow());
            try {
                FileOutputStream out = new FileOutputStream(file);
                long total = Tools.writeAll(out, attachment.getInputStream());
                UISupport.showInfoMessage("Written [" + total + "] bytes to " + file.getName());
            }
            catch (IOException e) {
                UISupport.showErrorMessage(e);
            }
        }
    }

    private void addFileBtnActionPerformed(ActionEvent evt) {
        int returnVal;
        if (this.fc == null) {
            this.fc = new JFileChooser();
        }
        if ((returnVal = this.fc.showOpenDialog(this)) == 0) {
            File file = this.fc.getSelectedFile();
            Boolean retval = UISupport.confirmOrCancel("Cache attachment in request?", "Att Attachment");
            if (retval == null) {
                return;
            }
            try {
                this.tableModel.addFile(file, retval);
            }
            catch (IOException e) {
                UISupport.showErrorMessage(e);
            }
        } else {
            System.out.println("Open command cancelled by user.");
        }
    }

    private void removeBtnActionPerformed(ActionEvent evt) {
        if (UISupport.confirm("Remove selected attachments?", "Remove Attachments")) {
            this.tableModel.removeAttachment(this.fileTable.getSelectedRows());
        }
    }

    private final class PartsComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private Attachment attachment;
        private WsdlAttachmentPart[] parts;

        public PartsComboBoxModel() {
            MockAttachmentPanel.this.mockOperation.addPropertyChangeListener(this);
        }

        public void release() {
            MockAttachmentPanel.this.mockOperation.removePropertyChangeListener(this);
        }

        public void init(Attachment attachment) {
            System.out.println("Initializing parts..");
            this.attachment = attachment;
            this.parts = MockAttachmentPanel.this.mockOperation.getDefinedAttachmentParts();
        }

        public Object getElementAt(int index) {
            return this.parts == null ? null : this.parts[index].getName();
        }

        public int getSize() {
            return this.parts == null ? 0 : this.parts.length;
        }

        public Object getSelectedItem() {
            return this.attachment == null ? null : this.attachment.getPart();
        }

        public void setSelectedItem(Object anItem) {
            if (this.attachment != null) {
                this.attachment.setPart((String)anItem);
            }
        }

        public void propertyChange(PropertyChangeEvent arg0) {
            if (arg0.getPropertyName().equals(WsdlRequest.ATTACHMENTS_PROPERTY) && arg0.getOldValue() == this.attachment && arg0.getNewValue() == null) {
                this.attachment = null;
                this.parts = null;
            }
        }
    }

    private class AttachmentPartCellEditor
    extends DefaultCellEditor {
        public AttachmentPartCellEditor() {
            super(new JComboBox(new PartsComboBoxModel()));
        }

        public void release() {
            ((PartsComboBoxModel)((JComboBox)this.editorComponent).getModel()).release();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((PartsComboBoxModel)((JComboBox)this.editorComponent).getModel()).init(MockAttachmentPanel.this.tableModel.getAttachmentAt(row));
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

