/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRunContext;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.model.mock.MockResult;
import com.eviware.soapui.model.mock.MockRunListener;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.support.xml.XmlUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.wsdl.Part;
import org.mortbay.jetty.Request;
import org.w3c.dom.Element;

public class WsdlMockRunner
implements MockRunner {
    private final WsdlMockService mockService;
    private List<WsdlMockResult> mockResults = Collections.synchronizedList(new LinkedList());
    private int maxResults = 100;
    private int removed = 0;
    private WsdlMockRunContext mockContext;

    public WsdlMockRunner(WsdlMockService mockService, WsdlTestRunContext context) throws Exception {
        MockRunListener[] mockRunListeners;
        this.mockService = mockService;
        this.mockContext = new WsdlMockRunContext(mockService, context);
        SoapUI.getMockEngine().startMockService(this);
        for (MockRunListener listener : mockRunListeners = mockService.getMockRunListeners()) {
            listener.onMockRunnerStart(this);
        }
    }

    public WsdlMockRunContext getMockContext() {
        return this.mockContext;
    }

    public void addMockResult(WsdlMockResult mockResult) {
        this.mockResults.add(mockResult);
        if (this.mockResults.size() > this.maxResults) {
            this.mockResults.remove(0);
            ++this.removed;
        }
    }

    public void stop() {
        MockRunListener[] mockRunListeners;
        SoapUI.getMockEngine().stopMockService(this);
        for (MockRunListener listener : mockRunListeners = this.mockService.getMockRunListeners()) {
            listener.onMockRunnerStop(this);
        }
    }

    public WsdlMockService getMockService() {
        return this.mockService;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WsdlMockResult dispatchRequest(HttpServletRequest request, HttpServletResponse response) throws DispatchException {
        block24: {
            result = null;
            mockRunListeners = this.mockService.getMockRunListeners();
            try {
                for (MockRunListener listener : mockRunListeners) {
                    listener.onMockRequest(this, request, response);
                }
                timestamp = System.currentTimeMillis();
                soapAction = request.getHeader("SOAPAction");
                mockRequest = new WsdlMockRequest(request, response, this.mockContext);
                soapVersion = mockRequest.getSoapVersion();
                if (soapVersion == null) {
                    throw new DispatchException("Unrecognized SOAP Version");
                }
                contentElm = mockRequest.getContentElement();
                if (contentElm == null) {
                    throw new DispatchException("Missing content element in body");
                }
                contentQName = XmlUtils.getQName(contentElm.getDomNode());
                contentChildNodes = null;
                c = 0;
lbl19:
                // 2 sources

                while (c < this.mockService.getMockOperationCount()) {
                    mockOperation = this.mockService.getMockOperationAt(c);
                    wsdlOperation = mockOperation.getOperation();
                    if (!(wsdlOperation == null || this.mockService.isRequireSoapVersion() && wsdlOperation.getInterface().getSoapVersion() != mockRequest.getSoapVersion())) {
                        v0 = action = wsdlOperation.getAction() == null ? "\"\"" : "\"" + wsdlOperation.getAction() + "\"";
                        if ((soapAction == null && wsdlOperation.getAction() == null || action.equals(soapAction) || wsdlOperation.getAction() != null && wsdlOperation.getAction().equals(soapAction)) && (qname = wsdlOperation.getRequestBodyElementQName()).equals(contentQName)) {
                            startTime = 0L;
                            if (wsdlOperation.getStyle().equals("Document")) {
                                startTime = System.nanoTime();
                                result = mockOperation.dispatchRequest(mockRequest, response);
                            } else if (wsdlOperation.getStyle().equals("RPC")) {
                                bindingOperation = wsdlOperation.getBindingOperation();
                                parts = bindingOperation.getOperation().getInput().getMessage().getOrderedParts(null);
                                if (contentChildNodes == null) {
                                    contentChildNodes = XmlUtils.getChildElements((Element)contentElm.getDomNode());
                                }
                                if (parts.size() > 0) {
                                    for (i = 0; i < contentChildNodes.getLength() && !parts.isEmpty(); ++i) {
                                        item = contentChildNodes.item(i);
                                        if (item.getNodeType() != 1) continue;
                                        for (j = 0; j < parts.size() && !item.getNodeName().equals(((Part)parts.get(j)).getName()); ++j) {
                                        }
                                        if (j == parts.size()) break;
                                        parts.remove(j);
                                    }
                                }
                                if (i == contentChildNodes.getLength() && parts.isEmpty()) {
                                    startTime = System.nanoTime();
                                    result = mockOperation.dispatchRequest(mockRequest, response);
                                }
                            }
                            if (startTime == 0L) {
                                throw new DispatchException("Failed to find matching operation for request");
                            }
                            ((Request)request).setHandled(true);
                            result.setTimeTaken((System.nanoTime() - startTime) / 1000000L);
                            result.setTimestamp(timestamp);
                            this.addMockResult(result);
                            var20_22 = result;
                            if (result == null) return var20_22;
                            arr$ = mockRunListeners;
                            break block24;
                        }
                    }
                    ** GOTO lbl-1000
                }
                throw new DispatchException("Missing operation for soapAction [" + soapAction + "] and body element [" + contentQName + "] with SOAP Version [" + mockRequest.getSoapVersion() + "]");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!(e instanceof DispatchException)) throw new DispatchException(e);
                throw (DispatchException)e;
            }
            catch (Throwable var25_30) {
                if (result == null) throw var25_30;
                for (MockRunListener listener : mockRunListeners) {
                    listener.onMockResult(result);
                }
                throw var25_30;
            }
        }
        for (MockRunListener listener : arr$) {
            listener.onMockResult(result);
        }
        return var20_22;
lbl-1000:
        // 1 sources

        {
            ++c;
            ** GOTO lbl19
        }
    }

    public MockResult getMockResultAt(int index) {
        return index <= this.removed ? null : this.mockResults.get(index - this.removed);
    }

    public int getMockResultCount() {
        return this.mockResults.size() + this.removed;
    }
}

