/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.mockservice;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class RemoveMockServiceAction
extends AbstractAction {
    private final WsdlMockService mockService;

    public RemoveMockServiceAction(WsdlMockService mockService) {
        super("Remove");
        this.mockService = mockService;
        this.putValue("ShortDescription", "Removes this MockService from the MockService");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("DELETE"));
    }

    public void actionPerformed(ActionEvent e) {
        if (SoapUI.getMockEngine().hasRunningMock(this.mockService)) {
            UISupport.showErrorMessage("Cannot remove MockService while mocks are running");
            return;
        }
        if (UISupport.confirm("Remove MockService [" + this.mockService.getName() + "] from MockService", "Remove MockService")) {
            this.mockService.getProject().removeMockService(this.mockService);
        }
    }
}

