/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.impl;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.intr.TuneOS;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;

public class TuneLinuxOS
extends TuneOS {
    private AMTuneConfigInfo confInfo;
    private AMTuneLogger pLogger;
    private MessageWriter mWriter;

    public void initialize(AMTuneConfigInfo configInfo) throws AMTuneException {
        this.confInfo = configInfo;
        this.pLogger = AMTuneLogger.getLoggerInst();
        this.mWriter = MessageWriter.getInstance();
    }

    public void startTuning() throws AMTuneException {
        try {
            this.mWriter.writelnLocaleMsg("pt-lnx-tuning");
            this.tuneKernel();
            this.tuneRcLocal();
            this.tuneSecurityLimits();
            this.mWriter.writelnLocaleMsg("pt-lnx-reboot-msg");
            this.mWriter.writeln("=====================================================================");
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "startTuning", "Error tuning linux system.");
            this.mWriter.writelnLocaleMsg("pt-error-tuning-msg");
            this.mWriter.writeLocaleMsg("pt-os-tuning-error-msg");
            this.mWriter.writelnLocaleMsg("pt-manual-msg");
            this.pLogger.logException("startTuning", ex);
        }
    }

    protected void tuneKernel() throws AMTuneException {
        try {
            FileHandler sysOutHdlr;
            String tuneFile = "/etc/sysctl.conf";
            ArrayList<String> recVals = new ArrayList<String>();
            FileHandler tuneFileFh = new FileHandler(tuneFile);
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-lnx-kernel-tuning-msg");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-file");
            this.mWriter.writeln(tuneFile);
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-file-max");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write("fs.file-max = ");
            String reqLine = tuneFileFh.getLine("fs.file-max");
            this.mWriter.writeln(AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            String recVal = "fs.file-max = 65536";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-dbflush-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = tuneFileFh.getLine("vm.bdflush");
            this.mWriter.writeln("vm.bdflush = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "vm.bdflush = 100 1200 128 512 15 5000 500 1884 2";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            String sysCtlCmd = "/sbin/sysctl ";
            StringBuffer rBuff = new StringBuffer();
            int extVal = AMTuneUtil.executeCommand(sysCtlCmd + "-a", rBuff);
            if (extVal != -1) {
                String sysOutTempFile = AMTuneUtil.TMP_DIR + "sysctlout";
                AMTuneUtil.writeResultBufferToTempFile(rBuff, sysOutTempFile);
                sysOutHdlr = new FileHandler(sysOutTempFile);
                File outFile = new File(sysOutTempFile);
                if (outFile.isFile()) {
                    outFile.delete();
                }
            } else {
                throw new AMTuneException("Error running sysctl cmd. ");
            }
            this.mWriter.writelnLocaleMsg("pt-lnx-ip-local-port-range");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.ip_local_port_range");
            this.mWriter.writeln("net.ipv4.ip_local_port_range = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.ip_local_port_range = 1204 65000";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writelnLocaleMsg("pt-lnx-core-rmem-max-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.core.rmem_max");
            this.mWriter.writeln("net.core.rmem_max = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.core.rmem_max = 262140";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-core-rmem-default-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.core.rmem_default");
            this.mWriter.writeln("net.core.rmem_default = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.core.rmem_default = 262140";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-rmem-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_rmem");
            this.mWriter.writeln("net.ipv4.tcp_rmem = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_rmem = 4096 131072 262140";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-wmem-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_wmem");
            this.mWriter.writeln("net.ipv4.tcp_wmem = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_wmem = 4096 131072 262140";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-sack-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_sack");
            this.mWriter.writeln("net.ipv4.tcp_sack = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_sack = 0";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-timestamps-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_timestamps");
            this.mWriter.writeln("net.ipv4.tcp_timestamps = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_timestamps = 0";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-window-scaling-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_window_scaling");
            this.mWriter.writeln("net.ipv4.tcp_window_scaling = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_window_scaling = 0";
            this.mWriter.writeln(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-keepalive-time-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_keepalive_time");
            this.mWriter.writeln("net.ipv4.tcp_keepalive_time = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_keepalive_time = 60000";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-keepalive-intvl-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_keepalive_intvl");
            this.mWriter.writeln("net.ipv4.tcp_keepalive_intvl = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_keepalive_intvl = 15000";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-tcp-fin-timeout-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            reqLine = sysOutHdlr.getLine("net.ipv4.tcp_fin_timeout");
            this.mWriter.writeln("net.ipv4.tcp_fin_timeout = " + AMTuneUtil.getLastToken(reqLine, "="));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "net.ipv4.tcp_fin_timeout = 30";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            if (this.confInfo.isReviewMode()) {
                return;
            }
            String[] delLines = new String[]{"Start: Federated Access Manager Tuning", "fs.file-max", "vm.bdflush", "net.ipv4.ip_local_port_range", "net.core.rmem_max", "net.core.rmem_default", "net.ipv4.tcp_rmem", "net.ipv4.tcp_wmem", "net.ipv4.tcp_sack", "net.ipv4.tcp_timestamps", "net.ipv4.tcp_window_scaling", "net.ipv4.tcp_keepalive_time", "net.ipv4.tcp_keepalive_intvl", "net.ipv4.tcp_fin_timeout", "End: Federated Access Manager Tuning"};
            AMTuneUtil.backupConfigFile(tuneFile);
            this.pLogger.log(Level.FINEST, "tuneKernel", "Removing existing configuration values from " + tuneFile);
            tuneFileFh.removeMatchingLines(delLines);
            tuneFileFh.appendLine("# Start: Federated Access Manager Tuning " + AMTuneUtil.getTodayDateStr());
            tuneFileFh.appendLine("# End: Federated Access Manager Tuning " + AMTuneUtil.getTodayDateStr());
            Iterator itr = recVals.iterator();
            while (itr.hasNext()) {
                tuneFileFh.appendLine((String)itr.next());
            }
            tuneFileFh.close();
            this.mWriter.writeLocaleMsg("pt-lnx-load-vals-msg");
            this.mWriter.writeln(" " + tuneFile);
            rBuff.setLength(0);
            extVal = AMTuneUtil.executeCommand(sysCtlCmd + " -p", rBuff);
            if (extVal != -1) {
                this.pLogger.log(Level.INFO, "tuneKernel", "Linux kernel tuning successful.");
            } else {
                this.mWriter.writelnLocaleMsg("pt-lnx-kernel-tuning-error-msg");
                this.pLogger.log(Level.SEVERE, "tuneKernel", "Error tuning Linux kernel.");
            }
        }
        catch (Exception ex) {
            this.pLogger.logException("tuneKernel", ex);
            throw new AMTuneException("Exception while tuning Linux kernel");
        }
    }

    protected void tuneTCP() throws AMTuneException {
    }

    private void tuneRcLocal() throws AMTuneException {
        try {
            String tuneFile = "/etc/rc.local";
            String recVal = "";
            ArrayList<String> recVals = new ArrayList<String>();
            FileHandler fh = new FileHandler(tuneFile);
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-lnx-boot-script-tuning-msg");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-file");
            this.mWriter.writeln(tuneFile);
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writeln("1.   /proc/sys/net/ipv4/tcp_fin_timeout");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(fh.getLine("/proc/sys/net/ipv4/tcp_fin_timeout"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "echo 30 > /proc/sys/net/ipv4/tcp_fin_timeout";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writeln("2.   /proc/sys/net/ipv4/tcp_keepalive_time");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(fh.getLine("/proc/sys/net/ipv4/tcp_keepalive_time"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "echo 60000 > /proc/sys/net/ipv4/tcp_keepalive_time";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writeln("3.   /proc/sys/net/ipv4/tcp_keepalive_intvl");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(fh.getLine("/proc/sys/net/ipv4/tcp_keepalive_intvl"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "echo 15000 > /proc/sys/net/ipv4/tcp_keepalive_intvl";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writeln("4.   /proc/sys/net/ipv4/tcp_window_scaling");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(fh.getLine("/proc/sys/net/ipv4/tcp_window_scaling"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "echo 0 > /proc/sys/net/ipv4/tcp_window_scaling";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writeln("5.   /proc/sys/vm/bdflush");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(fh.getLine("/proc/sys/vm/bdflush"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            recVal = "echo 100 1200 128 512 15 5000 500 1884 2 > /proc/sys/vm/bdflush";
            this.mWriter.writeln(recVal);
            recVals.add(recVal);
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-lnx-loading-kernel-msg");
            this.mWriter.writeln("sysctl -p /etc/sysctl.conf");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(fh.getLine("sysctl -p /etc/sysctl.conf"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("sysctl -p /etc/sysctl.conf");
            recVals.add("sysctl -p /etc/sysctl.conf");
            this.mWriter.writeln(" ");
            if (this.confInfo.isReviewMode()) {
                return;
            }
            AMTuneUtil.backupConfigFile(tuneFile);
            this.pLogger.log(Level.FINEST, "tuneRcLocal", "Removing existing configuration from " + tuneFile);
            String[] delLines = new String[]{"Start: Federated Access Manager Tuning", "/proc/sys/net/ipv4/tcp_fin_timeout", "/proc/sys/net/ipv4/tcp_keepalive_time", "/proc/sys/net/ipv4/tcp_keepalive_intvl", "/proc/sys/net/ipv4/tcp_window_scaling", "/proc/sys/vm/bdflush", "sysctl -p /etc/sysctl.conf", "End: Federated Access Manager Tuning"};
            fh.removeMatchingLines(delLines);
            this.pLogger.log(Level.FINEST, "tuneRcLocal", "Adding recomendations to the " + tuneFile);
            fh.appendLine("# Start: Federated Access Manager Tuning " + AMTuneUtil.getTodayDateStr());
            Iterator itr = recVals.iterator();
            while (itr.hasNext()) {
                fh.appendLine((String)itr.next());
            }
            fh.appendLine("# End: Federated Access Manager Tuning " + AMTuneUtil.getTodayDateStr());
            fh.close();
        }
        catch (Exception ex) {
            this.pLogger.logException("tuneRcLocal", ex);
            throw new AMTuneException("Error tuning Linux Boot file.");
        }
    }

    protected void tuneSecurityLimits() throws AMTuneException {
        try {
            String tuneFile = "/etc/security/limits.conf";
            FileHandler tuneFileFh = new FileHandler(tuneFile);
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-lnx-open-file-msg");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-file");
            this.mWriter.writeln(tuneFile);
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            String curNoFileSoftDomain = "";
            String newNoFileSoftString = "";
            String[] matLines = tuneFileFh.getMattchingLines("^#", true);
            String[] sofTlines = AMTuneUtil.getMatchedLines(matLines, "soft");
            String[] reqLns = AMTuneUtil.getMatchedLines(sofTlines, "nofile");
            if (reqLns.length > 0) {
                curNoFileSoftDomain = reqLns[0].substring(0, reqLns[0].indexOf(" "));
                newNoFileSoftString = curNoFileSoftDomain + "               soft    nofile          " + 65536;
            } else {
                newNoFileSoftString = "*               soft    nofile          65536";
            }
            String[] hardLines = AMTuneUtil.getMatchedLines(matLines, "hard");
            String[] noFLines = AMTuneUtil.getMatchedLines(hardLines, "nofile");
            String curNoFileHardDomain = "";
            String newNoFileHardString = "";
            if (noFLines.length > 0) {
                curNoFileHardDomain = noFLines[0].substring(0, noFLines[0].indexOf(" "));
                newNoFileHardString = curNoFileHardDomain.trim() + "               hard    nofile          " + 65536;
            } else {
                newNoFileHardString = "*               hard    nofile          65536";
            }
            this.mWriter.writelnLocaleMsg("pt-lnx-soft-file-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            if (reqLns.length > 0) {
                this.mWriter.writeln(reqLns[0]);
            } else {
                this.mWriter.writeln(" ");
            }
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(newNoFileSoftString);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-lnx-hard-file-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            if (noFLines.length > 0) {
                this.mWriter.writeln(noFLines[0]);
            } else {
                this.mWriter.writeln(" ");
            }
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(newNoFileHardString);
            if (this.confInfo.isReviewMode()) {
                return;
            }
            AMTuneUtil.backupConfigFile(tuneFile);
            this.pLogger.log(Level.FINEST, "tuneSecurityLimits", "Deleting configuration from " + tuneFile);
            String[] delLines = new String[]{"Start: Federated Access Manager Tuning", "End: Federated Access Manager Tuning"};
            tuneFileFh.removeMatchingLines(delLines);
            if (reqLns.length == 1) {
                tuneFileFh.removeMatchingLines(reqLns);
            }
            if (noFLines.length > 0) {
                tuneFileFh.removeMatchingLines(noFLines);
            }
            this.pLogger.log(Level.FINEST, "tuneSecurityLimits", "Modifying configuration file " + tuneFile);
            tuneFileFh.appendLine("# Start: Federated Access Manager Tuning " + AMTuneUtil.getTodayDateStr());
            tuneFileFh.appendLine(newNoFileSoftString);
            tuneFileFh.appendLine(newNoFileSoftString);
            tuneFileFh.appendLine("# End: Federated Access Manager Tuning " + AMTuneUtil.getTodayDateStr());
            tuneFileFh.close();
        }
        catch (Exception ex) {
            this.pLogger.logException("tuneSecurityLimits", ex);
            throw new AMTuneException("Error tuning limits.conf.");
        }
    }
}

