/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.impl;

import com.sun.identity.tune.base.AMTuneFAMBase;
import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class TuneFAM8Impl
extends AMTuneFAMBase {
    public void initialize(AMTuneConfigInfo configInfo) throws AMTuneException {
        super.initialize(configInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTuning() throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "startTuning", "Start tuning FAM.");
            this.mWriter.writeln("#####################################################################");
            this.mWriter.writelnLocaleMsg("pt-fam-tuning-msg");
            this.mWriter.writeln("#####################################################################");
            this.mWriter.writelnLocaleMsg("pt-init");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.tuneFAMServerConfig();
            this.tuneServerConfig();
            this.tuneLDAPConnPool();
            if (this.configInfo.getDefaultOrgPeopleContainer() != null && this.configInfo.getDefaultOrgPeopleContainer().trim().length() > 0) {
                this.tuneLDAPSearchCriteriaForDefaultOrg();
            }
            if (this.configInfo.getFAMTuneDontTouchSessionParameters()) {
                this.tuneSessionTimeouts();
            }
            List realmList = this.configInfo.getRealms();
            Iterator realmItr = realmList.iterator();
            while (realmItr.hasNext()) {
                String curRealm = realmItr.next().toString();
                if (!(curRealm != null & curRealm.trim().length() > 0)) continue;
                List dataStoreList = this.getDataStoreList(curRealm);
                Iterator dtItr = dataStoreList.iterator();
                while (dtItr.hasNext()) {
                    this.tuneRealmDataStoreConfig(dtItr.next().toString(), curRealm);
                }
            }
            this.mWriter.writeln("=====================================================================");
            this.mWriter.writelnLocaleMsg("pt-done");
        }
        catch (Exception ex) {
            this.pLogger.logException("startTuning", ex);
            this.mWriter.writelnLocaleMsg("pt-error-tuning-msg");
            this.mWriter.writelnLocaleMsg("pt-manual-msg");
        }
        finally {
            this.deletePasswordFile();
        }
    }

    protected void tuneFAMServerConfig() {
        ArrayList<String> newAttrList = new ArrayList<String>();
        Map curCfgMap = this.getFAMServerConfig();
        String ATTR1 = "com.iplanet.am.sdk.cache.maxSize=" + this.configInfo.getNumSessions();
        String ATTR2 = "com.iplanet.am.notification.threadpool.size=" + this.configInfo.getNumNotificationThreads();
        String ATTR3 = "com.iplanet.am.notification.threadpool.threshold=" + this.configInfo.getNumNotificationQueue();
        String ATTR4 = "com.iplanet.am.session.maxSessions=" + this.configInfo.getNumSessions();
        String ATTR5 = "com.iplanet.am.session.httpSession.enabled=false";
        String ATTR6 = "com.iplanet.am.session.purgedelay=0";
        String ATTR7 = "com.iplanet.am.session.invalidsessionmaxtime=2";
        String curVal = null;
        this.mWriter.writeln("---------------------------------------------------------------------");
        this.mWriter.writelnLocaleMsg("pt-fam-rec-parm-tune-msg");
        this.mWriter.writeln(" ");
        this.mWriter.writelnLocaleMsg("pt-param-tuning");
        this.mWriter.writeln(" ");
        this.mWriter.writeln("1.    com.iplanet.am.sdk.cache.maxSize");
        this.mWriter.writeLocaleMsg("pt-cur-val");
        if (curCfgMap.get("com.iplanet.am.sdk.cache.maxSize") != null) {
            curVal = curCfgMap.get("com.iplanet.am.sdk.cache.maxSize").toString();
            if (ATTR1.indexOf(curVal) == -1) {
                newAttrList.add(ATTR1);
            }
        } else {
            curVal = "<No value set>";
            newAttrList.add(ATTR1);
        }
        this.mWriter.writeln("com.iplanet.am.sdk.cache.maxSize=" + curVal);
        this.mWriter.writeLocaleMsg("pt-rec-val");
        this.mWriter.writeln(ATTR1);
        this.mWriter.writeln(" ");
        this.mWriter.writeln("2.    com.iplanet.am.notification.threadpool.size");
        this.mWriter.writeLocaleMsg("pt-cur-val");
        if (curCfgMap.get("com.iplanet.am.notification.threadpool.size") != null) {
            curVal = curCfgMap.get("com.iplanet.am.notification.threadpool.size").toString();
            if (ATTR2.indexOf(curVal) == -1) {
                newAttrList.add(ATTR2);
            }
        } else {
            curVal = "<No value set>";
            newAttrList.add(ATTR2);
        }
        this.mWriter.writeln("com.iplanet.am.notification.threadpool.size=" + curVal);
        this.mWriter.writeLocaleMsg("pt-rec-val");
        this.mWriter.writeln(ATTR2);
        this.mWriter.writeln(" ");
        this.mWriter.writeln("3.    com.iplanet.am.notification.threadpool.threshold");
        this.mWriter.writeLocaleMsg("pt-cur-val");
        if (curCfgMap.get("com.iplanet.am.notification.threadpool.threshold") != null) {
            curVal = curCfgMap.get("com.iplanet.am.notification.threadpool.threshold").toString();
            if (ATTR3.indexOf(curVal) == -1) {
                newAttrList.add(ATTR3);
            }
        } else {
            curVal = "<No value set>";
            newAttrList.add(ATTR3);
        }
        this.mWriter.writeln("com.iplanet.am.notification.threadpool.threshold=" + curVal);
        this.mWriter.writeLocaleMsg("pt-rec-val");
        this.mWriter.writeln(ATTR3);
        this.mWriter.writeln(" ");
        this.mWriter.writeln("4.    com.iplanet.am.session.maxSessions");
        this.mWriter.writeLocaleMsg("pt-cur-val");
        if (curCfgMap.get("com.iplanet.am.session.maxSessions") != null) {
            curVal = curCfgMap.get("com.iplanet.am.session.maxSessions").toString();
            if (ATTR4.indexOf(curVal) == -1) {
                newAttrList.add(ATTR4);
            }
        } else {
            curVal = "<No value set>";
            newAttrList.add(ATTR4);
        }
        this.mWriter.writeln("com.iplanet.am.session.maxSessions=" + curVal);
        this.mWriter.writeLocaleMsg("pt-rec-val");
        this.mWriter.writeln(ATTR4);
        this.mWriter.writeln(" ");
        this.mWriter.writeln("5.    com.iplanet.am.session.httpSession.enabled");
        this.mWriter.writeLocaleMsg("pt-cur-val");
        if (curCfgMap.get("com.iplanet.am.session.httpSession.enabled") != null) {
            curVal = curCfgMap.get("com.iplanet.am.session.httpSession.enabled").toString();
            if (ATTR5.indexOf(curVal) == -1) {
                newAttrList.add(ATTR5);
            }
        } else {
            curVal = "<No value set>";
            newAttrList.add(ATTR5);
        }
        this.mWriter.writeln("com.iplanet.am.session.httpSession.enabled=" + curVal);
        this.mWriter.writeLocaleMsg("pt-rec-val");
        this.mWriter.writeln(ATTR5);
        this.mWriter.writeln(" ");
        this.mWriter.writeln("6.    com.iplanet.am.session.purgedelay");
        this.mWriter.writeLocaleMsg("pt-cur-val");
        if (curCfgMap.get("com.iplanet.am.session.purgedelay") != null) {
            curVal = curCfgMap.get("com.iplanet.am.session.purgedelay").toString();
            if (Integer.parseInt(curVal) != 0) {
                newAttrList.add(ATTR6);
            }
        } else {
            curVal = "<No value set>";
            newAttrList.add(ATTR6);
        }
        this.mWriter.writeln("com.iplanet.am.session.purgedelay=" + curVal);
        this.mWriter.writeLocaleMsg("pt-rec-val");
        this.mWriter.writeln(ATTR6);
        this.mWriter.writeln(" ");
        this.mWriter.writeln("7.    com.iplanet.am.session.invalidsessionmaxtime");
        this.mWriter.writeLocaleMsg("pt-cur-val");
        if (curCfgMap.get("com.iplanet.am.session.invalidsessionmaxtime") != null) {
            curVal = curCfgMap.get("com.iplanet.am.session.invalidsessionmaxtime").toString();
            if (Integer.parseInt(curVal) != 2) {
                newAttrList.add(ATTR7);
            }
        } else {
            curVal = "<No value set>";
            newAttrList.add(ATTR7);
        }
        this.mWriter.writeln("com.iplanet.am.session.invalidsessionmaxtime=" + curVal);
        this.mWriter.writeLocaleMsg("pt-rec-val");
        this.mWriter.writeln(ATTR7);
        this.mWriter.writeln(" ");
        if (this.configInfo.isReviewMode()) {
            return;
        }
        this.mWriter.writelnLocaleMsg("pt-fam-tuning-server-config");
        if (newAttrList != null && newAttrList.size() > 0) {
            this.updateFAMServiceCfg(newAttrList);
        } else {
            this.mWriter.writelnLocaleMsg("pt-fam-cur-rec-val-same");
        }
        this.mWriter.writeln(" ");
    }

    protected void tuneServerConfig() throws AMTuneException {
        String tuneFile = AMTuneUtil.TMP_DIR + "serverconfig.xml";
        try {
            String newMinPool = "8";
            String newMaxPool = "32";
            StringBuffer getCmd = new StringBuffer(this.famCmdPath);
            getCmd.append("get-svrcfg-xml");
            getCmd.append(this.famadmCommonParamsNoServer);
            getCmd.append(" ");
            getCmd.append("--servername");
            getCmd.append(" ");
            getCmd.append(this.configInfo.getFAMServerUrl());
            getCmd.append(" ");
            getCmd.append("--outfile");
            getCmd.append(" ");
            getCmd.append(tuneFile);
            StringBuffer rBuff = new StringBuffer();
            int extVal = AMTuneUtil.executeCommand(getCmd.toString(), rBuff);
            if (extVal == -1) {
                this.pLogger.log(Level.SEVERE, "tuneServerConfig", "Couldn't get serverconfig.xml file");
                throw new AMTuneException("Error exectuing famadm get-svrcfg-xml");
            }
            FileHandler fh = new FileHandler(tuneFile);
            String reqLine = fh.getLine("name=\"sms\"");
            StringTokenizer strT = new StringTokenizer(reqLine, " ");
            String curMinConnPool = "";
            String curMaxConnPool = "";
            while (strT.hasMoreTokens()) {
                String token = strT.nextToken();
                if (token.indexOf("minConnPool") != -1) {
                    curMinConnPool = token.replace("minConnPool=", "").replace("\"", "").replace(">", "").trim();
                }
                if (token.indexOf("maxConnPool") == -1) continue;
                curMaxConnPool = token.replace("maxConnPool=", "").replace("\"", "").replace(">", "").trim();
            }
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-fam-tuning-ldap-con-pool");
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-fam-refer-guide-msg");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-minconpool-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln("minConnPool=" + curMinConnPool);
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("minConnPool=" + newMinPool);
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-maxconpool-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln("maxConnPool=" + curMaxConnPool);
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("maxConnPool=" + newMaxPool);
            this.mWriter.writeln(" ");
            this.mWriter.writeln(" ");
            if (this.configInfo.isReviewMode() || curMinConnPool.equals(newMinPool) && curMaxConnPool.equals(newMaxPool)) {
                return;
            }
            AMTuneUtil.backupConfigFile(tuneFile, "conf-fam-backup");
            int lineNo = fh.getLineNum("name=\"sms\"");
            reqLine = fh.getLine("name=\"sms\"");
            reqLine = reqLine.replace("minConnPool=\"" + curMinConnPool + "\"", "minConnPool=\"" + newMinPool + "\"");
            reqLine = reqLine.replace("maxConnPool=\"" + curMaxConnPool + "\"", "maxConnPool=\"" + newMaxPool + "\"");
            fh.replaceLine(lineNo, reqLine);
            lineNo = fh.getLineNum(" name=\"default\"");
            reqLine = fh.getLine(" name=\"default\"");
            String curDefaultMinConPoolVal = "";
            String curDefaultMaxConPoolVal = "";
            strT = new StringTokenizer(reqLine, " ");
            while (strT.hasMoreTokens()) {
                String token = strT.nextToken();
                if (token.indexOf("minConnPool") != -1) {
                    curDefaultMinConPoolVal = token.replace("minConnPool=", "").replace("\"", "").replace(">", "").trim();
                }
                if (token.indexOf("maxConnPool") == -1) continue;
                curDefaultMaxConPoolVal = token.replace("maxConnPool=", "").replace("\"", "").replace(">", "").trim();
            }
            reqLine = reqLine.replace("minConnPool=\"" + curDefaultMinConPoolVal + "\"", "minConnPool=\"" + newMinPool + "\"");
            reqLine = reqLine.replace("maxConnPool=\"" + curDefaultMaxConPoolVal + "\"", "maxConnPool=\"" + newMaxPool + "\"");
            fh.replaceLine(lineNo, reqLine);
            fh.close();
            rBuff.setLength(0);
            StringBuffer setCmd = new StringBuffer(this.famCmdPath);
            setCmd.append("set-svrcfg-xml");
            setCmd.append(this.famadmCommonParamsNoServer);
            setCmd.append(" ");
            setCmd.append("--servername");
            setCmd.append(" ");
            setCmd.append(this.configInfo.getFAMServerUrl());
            setCmd.append(" ");
            setCmd.append("--xmlfile");
            setCmd.append(" ");
            setCmd.append(tuneFile);
            extVal = AMTuneUtil.executeCommand(setCmd.toString(), rBuff);
            if (extVal == -1) {
                this.pLogger.log(Level.SEVERE, "tuneServerConfig", "Couldn't set serverconfig.xml file");
                throw new AMTuneException("Error exectuing famadm set-svrcfg-xml");
            }
        }
        catch (Exception ex) {
            throw new AMTuneException("Error while tuning server config. " + ex.getMessage());
        }
        finally {
            File f = new File(tuneFile);
            if (f.isFile()) {
                f.delete();
            }
        }
    }

    protected void tuneLDAPConnPool() throws AMTuneException {
        try {
            String minMaxRatio = "8:32";
            StringBuffer getCmd = new StringBuffer(this.famCmdPath);
            getCmd.append("get-attr-defs");
            getCmd.append(this.famadmCommonParamsNoServer);
            getCmd.append(" ");
            getCmd.append("--servicename");
            getCmd.append(" ");
            getCmd.append("iPlanetAMAuthService");
            getCmd.append(" ");
            getCmd.append("--schematype");
            getCmd.append(" ");
            getCmd.append("global");
            getCmd.append(" ");
            getCmd.append("--attributenames");
            getCmd.append(" ");
            getCmd.append("iplanet-am-auth-ldap-connection-pool-default-size");
            StringBuffer rBuff = new StringBuffer();
            int extVal = AMTuneUtil.executeCommand(getCmd.toString(), rBuff);
            if (extVal == -1) {
                this.pLogger.log(Level.SEVERE, "tuneLDAPConnPool", "Error getting ldapconnpool size.");
                throw new AMTuneException("Error executing famadm cmd get-attr-defs");
            }
            StringTokenizer str = new StringTokenizer(rBuff.toString(), "\n");
            String curLdapConVal = "";
            while (str.hasMoreTokens()) {
                String reqLine = str.nextToken();
                if (reqLine.indexOf("iplanet-am-auth-ldap-connection-pool-default-size") == -1) continue;
                curLdapConVal = AMTuneUtil.getLastToken(reqLine, "=");
            }
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-fam-tuning-global-auth-svc");
            this.mWriter.writeln(" ");
            this.mWriter.writeln("Service              : iPlanetAMAuthService");
            this.mWriter.writeln("SchemaType           : global");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writelnLocaleMsg("pt-fam-refer-guide-msg");
            this.mWriter.writeln(" ");
            this.mWriter.writeln("1.   iplanet-am-auth-ldap-connection-pool-default-size");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writelnLocaleMsg("iplanet-am-auth-ldap-connection-pool-default-size=" + curLdapConVal);
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("iplanet-am-auth-ldap-connection-pool-default-size=" + minMaxRatio);
            this.mWriter.writeln(" ");
            if (this.configInfo.isReviewMode() || minMaxRatio.equals(curLdapConVal)) {
                return;
            }
            StringBuffer setCmd = new StringBuffer(this.famCmdPath);
            setCmd.append("set-attr-defs");
            setCmd.append(this.famadmCommonParamsNoServer);
            setCmd.append(" ");
            setCmd.append("--servicename");
            setCmd.append(" ");
            setCmd.append("iPlanetAMAuthService");
            setCmd.append(" ");
            setCmd.append("--schematype");
            setCmd.append(" ");
            setCmd.append("global");
            setCmd.append(" ");
            setCmd.append("--attributevalues");
            if (!AMTuneUtil.isWindows2003()) {
                setCmd.append(" ");
                setCmd.append("iplanet-am-auth-ldap-connection-pool-default-size");
                setCmd.append("=");
                setCmd.append(minMaxRatio);
            } else {
                setCmd.append(" \"");
                setCmd.append("iplanet-am-auth-ldap-connection-pool-default-size");
                setCmd.append("=");
                setCmd.append(minMaxRatio);
                setCmd.append("\"");
            }
            rBuff.setLength(0);
            extVal = AMTuneUtil.executeCommand(setCmd.toString(), rBuff);
            if (extVal == -1) {
                this.pLogger.log(Level.SEVERE, "tuneLDAPConnPool", "Error setting ldapconnpool size.");
                throw new AMTuneException("Error executing famadm cmd set-attr-defs");
            }
        }
        catch (Exception ex) {
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected void tuneLDAPSearchCriteriaForDefaultOrg() {
        this.mWriter.writeln("---------------------------------------------------------------------");
        this.mWriter.writelnLocaleMsg("pt-fam-tuning-ldap-search-criteria");
        this.mWriter.writeln(" ");
        this.mWriter.writeln("Service              : iPlanetAMAuthLDAPService for Org");
        this.mWriter.writeln("SchemaType           : organization");
        this.mWriter.writelnLocaleMsg("pt-param-tuning");
        this.mWriter.writeln(" ");
        this.mWriter.writelnLocaleMsg("pt-fam-rec-tuning-msg");
        this.mWriter.writelnLocaleMsg("pt-fam-tuning-ldap-search-change-step");
        this.mWriter.writeln(" ");
        this.mWriter.writeln("1.   iplanet-am-auth-ldap-search-scope");
        this.mWriter.writeLocaleMsg("pt-rec-val");
        this.mWriter.writeln("iplanet-am-auth-ldap-search-scope=OBJECT");
        this.mWriter.writeln(" ");
        this.mWriter.writeln(" ");
    }

    protected void tuneSessionTimeouts() {
        this.mWriter.writeln("---------------------------------------------------------------------");
        this.mWriter.writelnLocaleMsg("pt-fam-tuning-session-svc");
        this.mWriter.writeln(" ");
        this.mWriter.writeln("Service              : iPlanetAMSessionService");
        this.mWriter.writeln("SchemaType           : Dynamic");
        this.mWriter.writelnLocaleMsg("pt-param-tuning");
        this.mWriter.writeln(" ");
        this.mWriter.writelnLocaleMsg("pt-fam-rec-tuning-msg");
        this.mWriter.writelnLocaleMsg("pt-fam-tuning-session-change-step");
        this.mWriter.writeln("1.   iplanet-am-session-max-session-time");
        this.mWriter.writeLocaleMsg("pt-rec-val");
        this.mWriter.writeln("iplanet-am-session-max-session-time=" + this.configInfo.getFAMTuneSessionMaxSessionTimeInMts());
        this.mWriter.writeln(" ");
        this.mWriter.writeln("2.   iplanet-am-session-max-idle-time");
        this.mWriter.writeLocaleMsg("pt-rec-val");
        this.mWriter.writeln("iplanet-am-session-max-idle-time=" + this.configInfo.getFAMTuneSessionMaxIdleTimeInMts());
        this.mWriter.writeln(" ");
        this.mWriter.writeln("3.   iplanet-am-session-max-caching-time");
        this.mWriter.writeLocaleMsg("pt-rec-val");
        this.mWriter.writeln("iplanet-am-session-max-caching-time=" + this.configInfo.getFAMTuneSessionMaxCachingTimeInMts());
        this.mWriter.writeln(" ");
        this.mWriter.writeln(" ");
    }

    protected void tuneRealmDataStoreConfig(String dataStoreType, String realm) throws AMTuneException {
        String dataFile = AMTuneUtil.TMP_DIR + "attrvals.txt";
        try {
            File dsF;
            String poolMin = "8";
            String poolMax = "32";
            this.mWriter.writeln("---------------------------------------------------------------------");
            StringBuffer dataStoreInfoCmd = new StringBuffer(this.famCmdPath);
            dataStoreInfoCmd.append("show-datastore");
            dataStoreInfoCmd.append(" -e ");
            dataStoreInfoCmd.append("REALM_NAME");
            dataStoreInfoCmd.append(" -m \"");
            dataStoreInfoCmd.append(dataStoreType);
            dataStoreInfoCmd.append("\"");
            dataStoreInfoCmd.append(this.famadmCommonParamsNoServer);
            StringBuffer dataStoreUpdateCmd = new StringBuffer(this.famCmdPath);
            dataStoreUpdateCmd.append("update-datastore");
            dataStoreUpdateCmd.append(" -e ");
            dataStoreUpdateCmd.append("REALM_NAME");
            dataStoreUpdateCmd.append(" -m \"");
            dataStoreUpdateCmd.append(dataStoreType);
            dataStoreUpdateCmd.append("\"");
            dataStoreUpdateCmd.append(this.famadmCommonParamsNoServer);
            StringBuffer attrVals = new StringBuffer("sun-idrepo-ldapv3-config-connection_pool_min_size");
            attrVals.append("=");
            attrVals.append(poolMin);
            attrVals.append("\n");
            attrVals.append("sun-idrepo-ldapv3-config-connection_pool_max_size");
            attrVals.append("=");
            attrVals.append(poolMax);
            AMTuneUtil.writeResultBufferToTempFile(attrVals, dataFile);
            dataStoreUpdateCmd.append(" -D ");
            dataStoreUpdateCmd.append(dataFile);
            this.mWriter.writeLocaleMsg("pt-tuning");
            this.mWriter.write("DataStore \"" + dataStoreType + "\" ");
            this.mWriter.writelnLocaleMsg("pt-fam-realm-ldapconn-tuning");
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writeln("Realm Name : " + realm + ":");
            this.mWriter.writelnLocaleMsg("pt-min-max-ldap-conn-pool");
            this.mWriter.writelnLocaleMsg("pt-cur-val");
            StringBuffer rBuf = new StringBuffer();
            int extVal = 0;
            extVal = !AMTuneUtil.isWindows2003() ? AMTuneUtil.executeScriptCmd(dataStoreInfoCmd.toString().replace("REALM_NAME", realm), rBuf) : AMTuneUtil.executeCommand(dataStoreInfoCmd.toString().replace("REALM_NAME", realm), rBuf);
            if (extVal == -1) {
                this.pLogger.log(Level.SEVERE, "tuneRealmDataStoreConfig", "Error finding realm ldap config info :" + rBuf.toString());
            }
            String dsFile = AMTuneUtil.TMP_DIR + realm.replace("/", "rdelim") + "datastore.txt";
            AMTuneUtil.writeResultBufferToTempFile(rBuf, dsFile);
            FileHandler fh = new FileHandler(dsFile);
            String curMax = AMTuneUtil.getLastToken(fh.getLine("sun-idrepo-ldapv3-config-connection_pool_max_size"), "=");
            String curMin = AMTuneUtil.getLastToken(fh.getLine("sun-idrepo-ldapv3-config-connection_pool_min_size"), "=");
            this.mWriter.writeln("sun-idrepo-ldapv3-config-connection_pool_min_size=" + curMin);
            this.mWriter.writeln("sun-idrepo-ldapv3-config-connection_pool_max_size=" + curMax);
            this.mWriter.writeln(" ");
            rBuf.setLength(0);
            this.mWriter.writelnLocaleMsg("pt-rec-val");
            this.mWriter.writeln("sun-idrepo-ldapv3-config-connection_pool_min_size=" + poolMin);
            this.mWriter.writeln("sun-idrepo-ldapv3-config-connection_pool_max_size=" + poolMax);
            if (this.configInfo.isReviewMode() || curMin.equals(poolMin) && curMax.equals(poolMax)) {
                return;
            }
            AMTuneUtil.backupConfigFile(dsFile, "conf-fam-backup");
            extVal = !AMTuneUtil.isWindows2003() ? AMTuneUtil.executeScriptCmd(dataStoreUpdateCmd.toString().replace("REALM_NAME", realm), rBuf) : AMTuneUtil.executeCommand(dataStoreUpdateCmd.toString().replace("REALM_NAME", realm), rBuf);
            if (extVal == -1) {
                this.pLogger.log(Level.SEVERE, "tuneRealmDataStoreConfig", "Error setting realm ldap config info :" + rBuf.toString());
            }
            if ((dsF = new File(dsFile)).isFile()) {
                dsF.delete();
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "tuneRealmDataStoreConfig", "Error tuning data store values. ");
            throw new AMTuneException(ex.getMessage());
        }
        finally {
            File delFile = new File(dataFile);
            if (delFile.isFile()) {
                delFile.delete();
            }
        }
    }
}

