/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.impl;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.config.AS9ContainerConfigInfo;
import com.sun.identity.tune.constants.WebContainerConstants;
import com.sun.identity.tune.intr.TuneAppServer;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class TuneAS9Container
extends TuneAppServer
implements WebContainerConstants {
    private AMTuneLogger pLogger = AMTuneLogger.getLoggerInst();
    private MessageWriter mWriter = MessageWriter.getInstance();
    private AMTuneConfigInfo configInfo;
    private AS9ContainerConfigInfo asConfigInfo;
    private Map curCfgMap;

    public void initialize(AMTuneConfigInfo confInfo) throws AMTuneException {
        try {
            this.configInfo = confInfo;
            this.asConfigInfo = (AS9ContainerConfigInfo)confInfo.getWSConfigInfo();
            this.curCfgMap = this.asConfigInfo.getCurASConfigInfo();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "initialize", "Error initializing Application server 9.1.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTuning() throws AMTuneException {
        try {
            this.mWriter.writelnLocaleMsg("pt-app-tuning-msg");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.tuneDomainXML();
            this.mWriter.writeln("=====================================================================");
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "startTuning", "Error Tuning Application server 9.1.");
            this.mWriter.writelnLocaleMsg("pt-error-tuning-msg");
            this.mWriter.writeLocaleMsg("pt-web-tuning-error-msg");
            this.mWriter.writelnLocaleMsg("pt-manual-msg");
            this.pLogger.logException("startTuning", ex);
        }
        finally {
            try {
                this.deletePasswordFile();
            }
            catch (Exception exception) {}
        }
    }

    protected void tuneDomainXML() throws AMTuneException {
        try {
            String tuneFile = this.asConfigInfo.getContainerInstanceDir() + "/" + "config" + "/" + "domain.xml";
            this.mWriter.writelnLocaleMsg("pt-app-srv-tuning-inst");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-file");
            this.mWriter.writeln(tuneFile + " (using asadmin command line tool)");
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-as-acceptor-threads-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln("acceptor-threads=" + this.curCfgMap.get(".acceptor-threads"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("acceptor-threads=" + this.configInfo.getAcceptorThreads());
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-as-pending-count-threads-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln("max-pending-count=" + this.curCfgMap.get("server.http-service.connection-pool.max-pending-count"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("max-pending-count=8192");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-as-queue-size-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln("queue-size=" + this.curCfgMap.get("server.http-service.connection-pool.queue-size-in-bytes"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln("queue-size=8192");
            this.mWriter.writeln(" ");
            String asAdminNewMinHeap = "-Xms" + this.configInfo.getMaxHeapSize() + "M";
            String asAdminNewMaxHeap = "-Xmx" + this.configInfo.getMaxHeapSize() + "M";
            this.mWriter.writelnLocaleMsg("pt-as-heap-size-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.write("Min Heap: " + this.curCfgMap.get("-Xms"));
            this.mWriter.writeln(" Max Heap: " + this.curCfgMap.get("-Xmx"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewMinHeap + " " + asAdminNewMaxHeap);
            this.mWriter.writeln(" ");
            String asAdminNewLoggcOutput = "-Xloggc:" + this.asConfigInfo.getContainerInstanceDir() + "/" + "logs" + "/" + "gc.log";
            this.mWriter.writelnLocaleMsg("pt-as-loggc-output-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-Xloggc"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewLoggcOutput);
            this.mWriter.writeln(" ");
            String asAdminNewServerMode = "-server";
            this.mWriter.writelnLocaleMsg("pt-as-server-mode-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            String modeFlag = (String)this.curCfgMap.get("-client");
            String modeFlagToDel = null;
            if (modeFlag != null && modeFlag.trim().length() > 0) {
                this.mWriter.writeln((String)this.curCfgMap.get("-client"));
                modeFlagToDel = "server.java-config.jvm-options = -client";
            } else {
                this.mWriter.writeln((String)this.curCfgMap.get("-server"));
            }
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewServerMode);
            this.mWriter.writeln(" ");
            String asAdminNewStackSize = "-Xss" + this.configInfo.getFAMTunePerThreadStackSizeInKB() + "k";
            this.mWriter.writelnLocaleMsg("pt-as-stack-size-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-Xss"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewStackSize);
            this.mWriter.writeln(" ");
            String asAdminNewNewSize = "-XX:NewSize=" + this.configInfo.getMaxNewSize() + "M";
            this.mWriter.writelnLocaleMsg("pt-as-new-size-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:NewSize"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewNewSize);
            this.mWriter.writeln(" ");
            String asAdminNewMaxNewSize = "-XX:MaxNewSize=" + this.configInfo.getMaxNewSize() + "M";
            this.mWriter.writelnLocaleMsg("pt-as-max-new-size-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:MaxNewSize"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewMaxNewSize);
            this.mWriter.writeln(" ");
            String asAdminNewDisableExplicitGc = "-XX:+DisableExplicitGC";
            this.mWriter.writelnLocaleMsg("pt-as-diable-gc-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:+DisableExplicitGC"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewDisableExplicitGc);
            this.mWriter.writeln(" ");
            String asAdminNewUseParallelGc = "-XX:+UseParNewGC";
            this.mWriter.writelnLocaleMsg("pt-as-use-parallel-gc-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:+UseParNewGC"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewUseParallelGc);
            this.mWriter.writeln(" ");
            String asAdminNewPrintClassHistogram = "-XX:+PrintClassHistogram";
            this.mWriter.writelnLocaleMsg("pt-as-histo-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:+PrintClassHistogram"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewPrintClassHistogram);
            this.mWriter.writeln(" ");
            String asAdminNewPrintGcTimeStamps = "-XX:+PrintGCTimeStamps";
            this.mWriter.writelnLocaleMsg("pt-as-gc-time-stamp-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:+PrintGCTimeStamps"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewPrintGcTimeStamps);
            this.mWriter.writeln(" ");
            String asAdminNewUseConMarkSweepGc = "-XX:+UseConcMarkSweepGC";
            this.mWriter.writelnLocaleMsg("pt-as-sweep-mark-gc-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln((String)this.curCfgMap.get("-XX:+UseConcMarkSweepGC"));
            this.mWriter.writeLocaleMsg("pt-rec-val");
            this.mWriter.writeln(asAdminNewUseConMarkSweepGc);
            this.mWriter.writeln(" ");
            String asAdminNewServerpolicy = "";
            if (this.asConfigInfo.isTuneWebContainerJavaPolicy()) {
                asAdminNewServerpolicy = "${com.sun.aas.instanceRoot}/config/server.policy.NOTUSED";
                this.mWriter.writelnLocaleMsg("pt-as-server-sec-policy-check-msg");
                this.mWriter.writeLocaleMsg("pt-cur-val");
                this.mWriter.write("-Djava.security.policy=");
                this.mWriter.writeln((String)this.curCfgMap.get("-Djava.security.policy"));
                this.mWriter.writeLocaleMsg("pt-rec-val");
                this.mWriter.write("-Djava.security.policy=");
                this.mWriter.writeln(asAdminNewServerpolicy);
                this.mWriter.writeln(" ");
            }
            String asadminNewParallelGCThreads = "";
            if (AMTuneUtil.isNiagara()) {
                asadminNewParallelGCThreads = "-XX:ParallelGCThreads=" + AMTuneUtil.getNumberOfCPUS();
                this.mWriter.writelnLocaleMsg("pt-as-parallel-gc-threads-msg");
                this.mWriter.writeLocaleMsg("pt-cur-val");
                this.mWriter.writeln((String)this.curCfgMap.get("-XX:ParallelGCThreads"));
                this.mWriter.writeLocaleMsg("pt-rec-val");
                this.mWriter.writeln(asadminNewParallelGCThreads);
                this.mWriter.writeln(" ");
            }
            if (this.configInfo.isReviewMode()) {
                return;
            }
            AMTuneUtil.backupConfigFile(tuneFile);
            this.setASParams();
            ArrayList<Object> delOptList = new ArrayList<Object>();
            delOptList.add(this.curCfgMap.get("-Xms"));
            delOptList.add(this.curCfgMap.get("-Xmx"));
            delOptList.add(this.curCfgMap.get("-Xloggc"));
            delOptList.add(this.curCfgMap.get("-client"));
            delOptList.add(this.curCfgMap.get("-Xss"));
            delOptList.add(this.curCfgMap.get("-XX:NewSize"));
            delOptList.add(this.curCfgMap.get("-XX:MaxNewSize"));
            delOptList.add(this.curCfgMap.get("-XX:+DisableExplicitGC"));
            delOptList.add(this.curCfgMap.get("-XX:+UseParNewGC"));
            delOptList.add(this.curCfgMap.get("-XX:+UseConcMarkSweepGC"));
            delOptList.add(this.curCfgMap.get("-XX:+PrintClassHistogram"));
            delOptList.add(this.curCfgMap.get("-XX:+PrintGCTimeStamps"));
            if (modeFlagToDel != null && modeFlagToDel.trim().length() > 0) {
                delOptList.add(modeFlagToDel);
            }
            if (this.asConfigInfo.isTuneWebContainerJavaPolicy()) {
                delOptList.add("-Djava.security.policy=" + this.curCfgMap.get("-Djava.security.policy"));
            }
            if (AMTuneUtil.isNiagara() && this.curCfgMap.get("-XX:ParallelGCThreads") != null && this.curCfgMap.get("-XX:ParallelGCThreads") != "<No value set>") {
                delOptList.add("-XX:ParallelGCThreads=" + this.curCfgMap.get("-XX:ParallelGCThreads"));
            }
            this.deleteCurJVMOptions(delOptList);
            ArrayList<String> newOptList = new ArrayList<String>();
            newOptList.add(asAdminNewMinHeap);
            newOptList.add(asAdminNewMaxHeap);
            newOptList.add(asAdminNewLoggcOutput);
            if (modeFlag != null && modeFlag.trim().length() > 0) {
                newOptList.add(asAdminNewServerMode);
            }
            newOptList.add(asAdminNewStackSize);
            newOptList.add(asAdminNewNewSize);
            newOptList.add(asAdminNewMaxNewSize);
            newOptList.add(asAdminNewDisableExplicitGc);
            newOptList.add(asAdminNewUseParallelGc);
            newOptList.add(asAdminNewUseConMarkSweepGc);
            newOptList.add(asAdminNewPrintClassHistogram);
            newOptList.add(asAdminNewPrintGcTimeStamps);
            if (this.asConfigInfo.isTuneWebContainerJavaPolicy()) {
                newOptList.add("-Djava.security.policy=" + asAdminNewServerpolicy);
            }
            if (AMTuneUtil.isNiagara() && asadminNewParallelGCThreads != null) {
                newOptList.add(asadminNewParallelGCThreads);
            }
            this.insertNewJVMOptions(newOptList);
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "tuneDomainXML", "Error tuning Application server 9.1 domain xml file.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    private void setASParams() {
        try {
            StringBuffer asAdminSetParams = new StringBuffer();
            asAdminSetParams.append(this.asConfigInfo.getAcceptorThreadString());
            asAdminSetParams.append("=");
            asAdminSetParams.append(this.configInfo.getAcceptorThreads());
            asAdminSetParams.append(" ");
            asAdminSetParams.append("server.http-service.connection-pool.max-pending-count");
            asAdminSetParams.append("=");
            asAdminSetParams.append(8192);
            asAdminSetParams.append(" ");
            asAdminSetParams.append("server.http-service.connection-pool.queue-size-in-bytes");
            asAdminSetParams.append("=");
            asAdminSetParams.append(8192);
            StringBuffer resultBuffer = new StringBuffer();
            StringBuffer setCmd = new StringBuffer(this.asConfigInfo.getASAdminCmd());
            setCmd.append("set ");
            setCmd.append(this.asConfigInfo.getAsAdminCommonParamsNoTarget());
            setCmd.append(" ");
            setCmd.append(asAdminSetParams.toString());
            int retVal = AMTuneUtil.executeCommand(setCmd.toString(), resultBuffer);
            if (retVal != 0) {
                this.mWriter.writelnLocaleMsg("pt-set-param-error-msg");
                this.mWriter.writelnLocaleMsg("pt-check-dbg-logs-msg");
                this.pLogger.log(Level.SEVERE, "setASParams", "Error executing asadmin " + resultBuffer.toString());
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "setASParams", "Application Server Parameters couldn't be set. " + ex.getMessage());
        }
    }

    private void deleteCurJVMOptions(List curJvmOptions) {
        try {
            StringBuffer delOpts = new StringBuffer();
            if (AMTuneUtil.isWindows2003()) {
                delOpts.append(" \"");
            } else {
                delOpts.append(" :");
            }
            Iterator optItr = curJvmOptions.iterator();
            while (optItr.hasNext()) {
                String val = optItr.next().toString().trim();
                if (val.length() <= 0 || val.equalsIgnoreCase("<No value set>")) continue;
                delOpts.append(":");
                val = val.replace(":", "\\:");
                delOpts.append(val);
            }
            if (AMTuneUtil.isWindows2003()) {
                delOpts.append("\"");
            }
            if (delOpts.toString().trim().length() < 3) {
                this.pLogger.log(Level.INFO, "deleteCurJVMOptions", "No JVM options to delete");
                return;
            }
            StringBuffer depOptCmd = new StringBuffer(this.asConfigInfo.getASAdminCmd());
            depOptCmd.append("delete-jvm-options ");
            depOptCmd.append(this.asConfigInfo.getAsAdminCommonParams());
            depOptCmd.append(delOpts.toString());
            StringBuffer resultBuffer = new StringBuffer();
            int retVal = AMTuneUtil.executeCommand(depOptCmd.toString(), resultBuffer);
            if (retVal != 0) {
                this.mWriter.writelnLocaleMsg("pt-del-jvm-error-msg");
                this.mWriter.writelnLocaleMsg("pt-check-dbg-logs-msg");
                this.pLogger.log(Level.SEVERE, "deleteCurJVMOptions", "Error running cmd " + depOptCmd + " \n Error msg :" + resultBuffer.toString());
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "deleteCurJVMOptions", "Error deleting JVM options. " + ex.getMessage());
        }
    }

    private void insertNewJVMOptions(List newJVMOpts) {
        try {
            StringBuffer newOpts = new StringBuffer();
            if (AMTuneUtil.isWindows2003()) {
                newOpts.append(" \"");
            } else {
                newOpts.append(" :");
            }
            Iterator optItr = newJVMOpts.iterator();
            while (optItr.hasNext()) {
                String val = optItr.next().toString().trim();
                if (val.length() <= 0) continue;
                newOpts.append(":");
                val = val.replace(":", "\\:");
                newOpts.append(val);
            }
            if (AMTuneUtil.isWindows2003()) {
                newOpts.append("\"");
            }
            if (newOpts.toString().trim().length() < 3) {
                this.pLogger.log(Level.INFO, "insertNewJVMOptions", "No JVM options to insert");
                return;
            }
            StringBuffer resultBuffer = new StringBuffer();
            StringBuffer newOptCmd = new StringBuffer(this.asConfigInfo.getASAdminCmd());
            newOptCmd.append("create-jvm-options ");
            newOptCmd.append(this.asConfigInfo.getAsAdminCommonParams());
            newOptCmd.append(newOpts.toString());
            int retVal = AMTuneUtil.executeCommand(newOptCmd.toString(), resultBuffer);
            if (retVal != 0) {
                this.mWriter.writelnLocaleMsg("pt-create-jvm-opts-error-msg");
                this.mWriter.writelnLocaleMsg("pt-check-dbg-logs-msg");
                this.pLogger.log(Level.SEVERE, "insertNewJVMOptions", "Error running cmd " + newOptCmd.toString() + " \n Error msg :" + resultBuffer.toString());
            }
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "insertNewJVMOptions", "Error setting new JVM options. " + ex.getMessage());
        }
    }

    protected void tuneSecurityLimits() throws AMTuneException {
        try {
            String tuneFile = "/etc/security/limits.conf";
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-app-stack-size-tuning");
            this.mWriter.writeln(" ");
            this.mWriter.writeLocaleMsg("pt-file");
            this.mWriter.writeln(tuneFile);
            this.mWriter.writelnLocaleMsg("pt-param-tuning");
            FileHandler fh = new FileHandler(tuneFile);
            String[] mLines = fh.getMattchingLines("^#", true);
            mLines = AMTuneUtil.getMatchedLines(mLines, "stack");
            mLines = AMTuneUtil.getMatchedLines(mLines, "hard");
            String newStackSize = "";
            String curStackSizeStr = " ";
            if (mLines.length > 0) {
                String firCol = mLines[0].substring(0, mLines[0].indexOf(" "));
                newStackSize = firCol + "               " + "hard    " + "stack          " + "256";
                curStackSizeStr = mLines[0];
            } else {
                newStackSize = "*               hard    stack          256";
            }
            this.mWriter.writelnLocaleMsg("pt-stack-size-msg");
            this.mWriter.writeLocaleMsg("pt-cur-val");
            this.mWriter.writeln(curStackSizeStr);
            this.mWriter.writelnLocaleMsg("pt-rec-val");
            this.mWriter.writeln(newStackSize);
            if (this.configInfo.isReviewMode()) {
                return;
            }
            String[] delLines = new String[]{"Start: AS9.1 Federated Access Manager Tuning :", "End: AS9.1 Federated Access Manager Tuning :"};
            if (curStackSizeStr != null && curStackSizeStr.trim().length() > 0) {
                delLines[2] = curStackSizeStr;
            }
            fh.removeMatchingLines(delLines);
            fh.appendLine("# " + delLines[0] + AMTuneUtil.getTodayDateStr());
            fh.appendLine(newStackSize);
            fh.appendLine("# " + delLines[1] + AMTuneUtil.getTodayDateStr());
            fh.close();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "tuneSecurityLimits", "Error tuning security limits " + ex.getMessage());
            throw new AMTuneException(ex.getMessage());
        }
    }

    private void deletePasswordFile() {
        File passFile = new File(this.asConfigInfo.getAdminPassfilePath());
        if (passFile.isFile()) {
            passFile.delete();
        }
    }
}

