/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.config;

import com.sun.identity.tune.base.WebContainerConfigInfoBase;
import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.config.AS9ContainerConfigInfo;
import com.sun.identity.tune.config.DSConfigInfo;
import com.sun.identity.tune.config.WS7ContainerConfigInfo;
import com.sun.identity.tune.constants.AMTuneConstants;
import com.sun.identity.tune.constants.DSConstants;
import com.sun.identity.tune.constants.FAMConstants;
import com.sun.identity.tune.constants.WebContainerConstants;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class AMTuneConfigInfo
implements AMTuneConstants,
DSConstants,
FAMConstants,
WebContainerConstants {
    private String confFileName;
    private AMTuneLogger pLogger;
    private MessageWriter mWriter;
    private boolean isReviewMode;
    private boolean tuneOS;
    private boolean tuneWebContainer;
    private boolean tuneDS;
    private boolean tuneFAM;
    private boolean isJVM64BitAvailable;
    private String osType;
    private String osPlatform;
    private String hostName;
    private String webContainer;
    private String famAdmLocation;
    private String famConfigDir;
    private String famServerUrl;
    private String famAdmUser;
    private String defaultOrgPeopleContainer;
    private int famTunePctMemoryToUse;
    private int famTunePerThreadStackSizeInKB;
    private int famTunePerThreadStackSizeInKB64Bit;
    private boolean famTuneDontTouchSessionParameters;
    private int famTuneSessionMaxSessionTimeInMts;
    private int famTuneSessionMaxIdleTimeInMts;
    private int famTuneSessionMaxCachingTimeInMts;
    private double famTuneMemMaxHeapSizeRatio;
    private double famTuneMemMinHeapSizeRatio;
    private int famTuneMinMemoryToUseInMB;
    private int famTuneMaxMemoryToUseInMB;
    private int famTuneMaxMemoryToUseInMBDefault;
    private String famTuneMemMaxHeapSizeRatioExp;
    private String famAdminPassword;
    private List realms;
    private String perlBinDir;
    private int gcThreads;
    private int acceptorThreads;
    private int numNotificationQueue;
    private int numNotificationThreads;
    private int numSMLdapThreads;
    private int numLdapAuthThreads;
    private int numRQThrottle;
    private int numOfMaxThreadPool;
    private int numCpus;
    private int memAvail;
    private int memToUse;
    private int maxHeapSize;
    private int minHeapSize;
    private int maxNewSize;
    private int maxPermSize;
    private int cacheSize;
    private int sdkCacheSize;
    private int numSDKCacheEntries;
    private int sessionCacheSize;
    private int numSessions;
    private double amTuneMaxNoThreads;
    private double amTuneMaxNoThreads64Bit;
    private int maxThreads;
    private WebContainerConfigInfoBase webConfigInfo = null;
    private ResourceBundle confBundle;
    private DSConfigInfo dsConfigInfo;
    private DSConfigInfo smConfigInfo;
    private boolean isUMSMDSSame;
    private boolean tuneUMOnly;

    public AMTuneConfigInfo(String confFileName) throws AMTuneException {
        this.confFileName = confFileName;
        this.pLogger = AMTuneLogger.getLoggerInst();
        this.mWriter = MessageWriter.getInstance();
        this.initialize();
    }

    private void initialize() throws AMTuneException {
        try {
            this.confBundle = ResourceBundle.getBundle(this.confFileName);
            this.setReviewMode(this.confBundle.getString("AMTUNE_MODE"));
            this.setLogType(this.confBundle.getString("AMTUNE_LOG_LEVEL"));
            this.setTuneOS(this.confBundle.getString("AMTUNE_TUNE_OS"));
            this.setTuneWebContainer(this.confBundle.getString("AMTUNE_TUNE_WEB_CONTAINER"));
            this.setWebContainer(this.confBundle.getString("WEB_CONTAINER"));
            if (this.isTuneWebContainer() || this.isTuneFAM()) {
                if (this.getWebContainer().equals("WS7")) {
                    this.webConfigInfo = new WS7ContainerConfigInfo(this.confBundle);
                } else if (this.getWebContainer().equals("AS91")) {
                    this.webConfigInfo = new AS9ContainerConfigInfo(this.confBundle);
                }
            }
            this.isJVM64BitAvailable = this.webConfigInfo != null ? this.webConfigInfo.isJVM64Bit() : false;
            this.setTuneDS(this.confBundle.getString("AMTUNE_TUNE_DS"));
            this.setTuneFAM(this.confBundle.getString("AMTUNE_TUNE_IDENTITY"));
            if (this.isTuneFAM()) {
                this.setFamAdminPassword(this.confBundle.getString("FAMADM_PASSWORD"));
                this.setFAMServerUrl(this.confBundle.getString("FAMSERVER_URL"));
                this.setFAMAdmUser(this.confBundle.getString("FAMADM_USER"));
                this.setRealms(this.confBundle.getString("REALM_NAME"));
                this.setFAMAdmLocation(this.confBundle.getString("FAMADM_LOCATION"));
                this.setFAMConfigDir(this.confBundle.getString("FAM_CONFIG_DIR"));
            }
            this.setFAMTuneMinMemoryToUseInMB(this.confBundle.getString("AMTUNE_MIN_MEMORY_TO_USE_IN_MB"));
            this.setFAMTuneMaxMemoryToUseInMBDefault(this.confBundle.getString("AMTUNE_MAX_MEMORY_TO_USE_IN_MB_DEFAULT"));
            this.setFAMTuneMaxMemoryToUseInMB();
            this.setFAMTunePerThreadStackSizeInKB(this.confBundle.getString("AMTUNE_PER_THREAD_STACK_SIZE_IN_KB"));
            this.setFAMTunePerThreadStackSizeInKB64Bit(this.confBundle.getString("AMTUNE_PER_THREAD_STACK_SIZE_IN_KB_64_BIT"));
            this.setFAMTuneDontTouchSessionParameters(this.confBundle.getString("AMTUNE_DONT_TOUCH_SESSION_PARAMETERS"));
            this.setFAMTunePctMemoryToUse(this.confBundle.getString("AMTUNE_PCT_MEMORY_TO_USE"));
            this.setFAMTuneSessionMaxSessionTimeInMts(this.confBundle.getString("AMTUNE_SESSION_MAX_SESSION_TIME_IN_MTS"));
            this.setFAMTuneSessionMaxIdleTimeInMts(this.confBundle.getString("AMTUNE_SESSION_MAX_IDLE_TIME_IN_MTS"));
            this.setFAMTuneSessionMaxCachingTimeInMts(this.confBundle.getString("AMTUNE_SESSION_MAX_CACHING_TIME_IN_MTS"));
            this.setFAMTuneMemMaxHeapSizeRatio(this.confBundle.getString("AMTUNE_MEM_MAX_HEAP_SIZE_RATIO"));
            this.setFAMTuneMemMinHeapSizeRatio(this.confBundle.getString("AMTUNE_MEM_MIN_HEAP_SIZE_RATIO"));
            this.setDefaultOrgPeopleContainer(this.confBundle.getString("DEFAULT_ORG_PEOPLE_CONTAINER"));
            if (this.isTuneDS()) {
                this.setUMSMDSSame(this.confBundle.getString("IS_UM_SM_DATASTORE_SAME"));
                this.setTuneUMOnly(this.confBundle.getString("TUNE_UM_ONLY"));
                this.dsConfigInfo = new DSConfigInfo(this.confBundle, false);
                if (!this.isUMSMDSSame()) {
                    this.smConfigInfo = new DSConfigInfo(this.confBundle, true);
                }
            }
            this.calculateTuneParams();
        }
        catch (Exception ex) {
            this.pLogger.logException("initialize", ex);
            throw new AMTuneException("Couldn't initialize configuration data");
        }
    }

    private void setRealms(String realmNames) throws AMTuneException {
        if (realmNames != null && realmNames.trim().length() > 0) {
            if (realmNames.indexOf("|") != -1) {
                this.realms = AMTuneUtil.getTokensList(realmNames, "|");
            } else {
                this.realms = new ArrayList();
                this.realms.add(realmNames);
            }
        } else {
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            AMTuneUtil.printErrorMsg("REALM_NAME");
            this.pLogger.log(Level.SEVERE, "setRealms", "Error setting Realms. Please check the value for the property REALM_NAME");
            throw new AMTuneException("Invalid value for REALM_NAME");
        }
    }

    public List getRealms() {
        return this.realms;
    }

    private void setReviewMode(String reviewMode) {
        this.isReviewMode = reviewMode == null || !reviewMode.trim().equalsIgnoreCase("CHANGE");
        this.pLogger.log(Level.INFO, "setReviewMode", "Review mode is set to : " + this.isReviewMode);
    }

    public boolean isReviewMode() {
        return this.isReviewMode;
    }

    private void setLogType(String logType) {
        if (logType != null && logType.trim().equals("NONE")) {
            MessageWriter.setWriteToFile(true);
            MessageWriter.setWriteToTerm(false);
        } else if (logType != null && logType.trim().equals("TERM")) {
            MessageWriter.setWriteToFile(false);
            MessageWriter.setWriteToTerm(true);
        } else if (logType != null && logType.trim().equals("FILE")) {
            MessageWriter.setWriteToFile(true);
            MessageWriter.setWriteToTerm(true);
        }
    }

    private void setTuneOS(String value) {
        if (value != null && value.equalsIgnoreCase("true")) {
            this.tuneOS = true;
        } else {
            this.tuneOS = false;
            this.pLogger.log(Level.INFO, "setTuneOS", "OS will not be tuned.");
        }
    }

    public boolean isTuneOS() {
        return this.tuneOS;
    }

    private void setTuneWebContainer(String value) {
        if (value != null && value.equalsIgnoreCase("true")) {
            this.tuneWebContainer = true;
        } else {
            this.tuneWebContainer = false;
            this.pLogger.log(Level.INFO, "setTuneWebContainer", "Web container will not be tuned.");
        }
    }

    public boolean isTuneWebContainer() {
        return this.tuneWebContainer;
    }

    private void setTuneDS(String value) {
        if (value != null && value.equals("true")) {
            this.tuneDS = true;
        } else {
            this.tuneDS = false;
            this.pLogger.log(Level.INFO, "setTuneDS", "Directory Server will not be tuned.");
        }
    }

    public boolean isTuneDS() {
        return this.tuneDS;
    }

    private void setTuneFAM(String value) {
        if (value != null && value.equals("true")) {
            this.tuneFAM = true;
        } else {
            this.tuneFAM = false;
            this.pLogger.log(Level.INFO, "setTuneFAM", "Federated AccessManager will not be tuned.");
        }
    }

    public boolean isTuneFAM() {
        return this.tuneFAM;
    }

    private void setOSType() {
        this.osType = System.getProperty("os.name");
    }

    public String getOSType() {
        return this.osType;
    }

    private void setOSPlatform() {
        this.osPlatform = System.getProperty("os.arch");
    }

    public String getOSPlatform() {
        return this.osPlatform;
    }

    private void setHostName() {
        this.hostName = AMTuneUtil.getHostName();
    }

    public String getHostName() {
        return this.hostName;
    }

    private void setWebContainer(String webContainer) throws AMTuneException {
        if (webContainer == null || webContainer.trim().length() <= 0 || !AMTuneUtil.isSupportedWebContainer(webContainer.trim())) {
            this.pLogger.log(Level.SEVERE, "setWebContainer", "Unsupported web container.  Please check the value for WEB_CONTAINER");
            this.mWriter.writelnLocaleMsg("pt-webcon-not-supported");
            AMTuneUtil.printErrorMsg("WEB_CONTAINER");
            throw new AMTuneException("Unsupported Web Container");
        }
        this.webContainer = webContainer.trim();
    }

    public String getWebContainer() {
        return this.webContainer;
    }

    private void setFAMAdmLocation(String famAdmLocation) throws AMTuneException {
        if (famAdmLocation != null && famAdmLocation.trim().length() > 0) {
            File famDir = new File(famAdmLocation);
            if (!famDir.isDirectory()) {
                this.mWriter.write(famAdmLocation + " ");
                this.mWriter.writeLocaleMsg("pt-not-valid-dir");
                this.pLogger.log(Level.SEVERE, "setFAMAdmLocation", "FAM Admin tools location is not valid Directory. Please check the value for the property FAMADM_LOCATION");
                throw new AMTuneException("Invalid FAM admin tools location");
            }
        } else {
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            AMTuneUtil.printErrorMsg("FAMADM_LOCATION");
            this.pLogger.log(Level.SEVERE, "setFAMAdmLocation", "Error setting FAM Admin Location. Please check the value for the property FAMADM_LOCATION");
            throw new AMTuneException("Invalid value for FAMADM_LOCATION");
        }
        this.famAdmLocation = famAdmLocation.trim();
    }

    public String getFAMAdmLocation() {
        return this.famAdmLocation;
    }

    private void setFAMConfigDir(String famConfigDir) throws AMTuneException {
        if (famConfigDir != null && famConfigDir.trim().length() > 0) {
            File famDir = new File(famConfigDir);
            if (!famDir.isDirectory()) {
                this.mWriter.write(famConfigDir + " ");
                this.mWriter.writeLocaleMsg("pt-not-valid-dir");
                this.pLogger.log(Level.SEVERE, "setFAMAdmLocation", "FAM config is not valid Directory. Please check the value for the property FAM_CONFIG_DIR");
                throw new AMTuneException("Invalid FAM install location");
            }
        } else {
            this.mWriter.writelnLocaleMsg("pt-inval-config");
            AMTuneUtil.printErrorMsg("FAM_CONFIG_DIR");
            this.pLogger.log(Level.SEVERE, "setFAMAdmLocation", "Error setting FAM config Location. Please check the value for the property FAM_CONFIG_DIR");
            throw new AMTuneException("Invalid value for FAM_CONFIG_DIR");
        }
        this.famConfigDir = famConfigDir.trim();
    }

    public String getFAMConfigDir() {
        return this.famConfigDir;
    }

    private void setFAMServerUrl(String famServerUrl) throws AMTuneException {
        if (famServerUrl == null || famServerUrl.trim().length() <= 0) {
            this.mWriter.writelnLocaleMsg("pt-fam-server-url-not-found");
            AMTuneUtil.printErrorMsg("FAMSERVER_URL");
            this.pLogger.log(Level.SEVERE, "setFAMServerUrl", "Error setting FAM Server URL. Please check the value for the property FAMSERVER_URL");
            throw new AMTuneException("Invalid value for FAMSERVER_URL");
        }
        this.famServerUrl = famServerUrl;
    }

    public String getFAMServerUrl() {
        return this.famServerUrl;
    }

    private void setFAMAdmUser(String famAdmUser) throws AMTuneException {
        if (famAdmUser == null || famAdmUser.trim().length() <= 0) {
            this.mWriter.writelnLocaleMsg("pt-fam-admin-user-not-found");
            AMTuneUtil.printErrorMsg("FAMADM_USER");
            this.pLogger.log(Level.SEVERE, "setFAMServerUrl", "Error setting FAM Admin User. Please check the value for the property FAMADM_USER");
            throw new AMTuneException("Invalid value for FAMADM_USER");
        }
        this.famAdmUser = famAdmUser;
    }

    public String getFAMAdmUser() {
        return this.famAdmUser;
    }

    private void setDefaultOrgPeopleContainer(String defaultOrgPeopleContainer) {
        this.defaultOrgPeopleContainer = defaultOrgPeopleContainer;
    }

    public String getDefaultOrgPeopleContainer() {
        return this.defaultOrgPeopleContainer;
    }

    public void setFAMTunePctMemoryToUse(String famTunePctMemoryToUse) throws AMTuneException {
        try {
            this.famTunePctMemoryToUse = Integer.parseInt(famTunePctMemoryToUse.trim());
            if (this.famTunePctMemoryToUse > 100) {
                this.pLogger.log(Level.WARNING, "setFAMTunePctMemoryToUse", "AMTUNE_PCT_MEMORY_TO_USE value is > 100 so using default value 100.");
                this.famTunePctMemoryToUse = 100;
            } else if (this.famTunePctMemoryToUse < 0) {
                this.pLogger.log(Level.WARNING, "setFAMTunePctMemoryToUse", "AMTUNE_PCT_MEMORY_TO_USE value is < 0 so using default value 0.");
                this.famTunePctMemoryToUse = 0;
            }
        }
        catch (Exception ex) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_PCT_MEMORY_TO_USE");
            this.pLogger.log(Level.SEVERE, "setFAMTunePctMemoryToUse", "Error setting % memory to use, make sure the value for AMTUNE_PCT_MEMORY_TO_USE is valid Integer.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    private int getFAMTunePctMemoryToUse() {
        return this.famTunePctMemoryToUse;
    }

    private void setFAMTunePerThreadStackSizeInKB(String famTunePerThreadStackSizeInKB) throws AMTuneException {
        try {
            this.famTunePerThreadStackSizeInKB = Integer.parseInt(famTunePerThreadStackSizeInKB.trim());
        }
        catch (Exception ex) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_PER_THREAD_STACK_SIZE_IN_KB");
            this.pLogger.log(Level.SEVERE, "setFAMTunePerThreadStackSizeInKB", "Error parsing value, make sure the value for AMTUNE_PER_THREAD_STACK_SIZE_IN_KB is valid Integer. ");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public int getFAMTunePerThreadStackSizeInKB() {
        return this.famTunePerThreadStackSizeInKB;
    }

    private void setFAMTunePerThreadStackSizeInKB64Bit(String famTunePerThreadStackSizeInKB64Bit) throws AMTuneException {
        try {
            this.famTunePerThreadStackSizeInKB64Bit = Integer.parseInt(famTunePerThreadStackSizeInKB64Bit.trim());
        }
        catch (Exception ex) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_PER_THREAD_STACK_SIZE_IN_KB_64_BIT");
            this.pLogger.log(Level.SEVERE, "setFAMTunePerThreadStackSizeInKB64Bit", "Error setting value, make sure the value for AMTUNE_PER_THREAD_STACK_SIZE_IN_KB_64_BIT is valid Integer. ");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public int getFAMTunePerThreadStackSizeInKB64Bit() {
        return this.famTunePerThreadStackSizeInKB64Bit;
    }

    private void setFAMTuneDontTouchSessionParameters(String amTuneDontTouchSessionParameters) {
        this.famTuneDontTouchSessionParameters = Boolean.parseBoolean(amTuneDontTouchSessionParameters);
    }

    public boolean getFAMTuneDontTouchSessionParameters() {
        return this.famTuneDontTouchSessionParameters;
    }

    private void setFAMTuneSessionMaxSessionTimeInMts(String famTuneSessionMaxSessionTimeInMts) throws AMTuneException {
        try {
            this.famTuneSessionMaxSessionTimeInMts = !this.getFAMTuneDontTouchSessionParameters() && famTuneSessionMaxSessionTimeInMts == null ? 60 : Integer.parseInt(famTuneSessionMaxSessionTimeInMts.trim());
        }
        catch (Exception ex) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_SESSION_MAX_SESSION_TIME_IN_MTS");
            this.pLogger.log(Level.SEVERE, "setFAMTuneSessionMaxSessionTimeInMts", "Error setting value, make sure the value for AMTUNE_SESSION_MAX_SESSION_TIME_IN_MTS is valid Integer.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public int getFAMTuneSessionMaxSessionTimeInMts() {
        return this.famTuneSessionMaxSessionTimeInMts;
    }

    private void setFAMTuneSessionMaxIdleTimeInMts(String famTuneSessionMaxIdleTimeInMts) throws AMTuneException {
        try {
            this.famTuneSessionMaxIdleTimeInMts = !this.getFAMTuneDontTouchSessionParameters() && famTuneSessionMaxIdleTimeInMts == null ? 10 : Integer.parseInt(famTuneSessionMaxIdleTimeInMts.trim());
        }
        catch (Exception ex) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_SESSION_MAX_IDLE_TIME_IN_MTS");
            this.pLogger.log(Level.SEVERE, "setFAMTuneSessionMaxIdleTimeInMts", "Error setting value, make sure the value for AMTUNE_SESSION_MAX_IDLE_TIME_IN_MTS is valid Integer.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public int getFAMTuneSessionMaxIdleTimeInMts() {
        return this.famTuneSessionMaxIdleTimeInMts;
    }

    private void setFAMTuneSessionMaxCachingTimeInMts(String famTuneSessionMaxCachingTimeInMts) throws AMTuneException {
        try {
            this.famTuneSessionMaxCachingTimeInMts = !this.getFAMTuneDontTouchSessionParameters() && famTuneSessionMaxCachingTimeInMts == null ? 2 : Integer.parseInt(famTuneSessionMaxCachingTimeInMts.trim());
        }
        catch (Exception ex) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_SESSION_MAX_CACHING_TIME_IN_MTS");
            this.pLogger.log(Level.SEVERE, "setFAMTuneSessionMaxCachingTimeInMts", "Error setting value, make sure the value for AMTUNE_SESSION_MAX_CACHING_TIME_IN_MTS is valid Integer.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public int getFAMTuneSessionMaxCachingTimeInMts() {
        return this.famTuneSessionMaxCachingTimeInMts;
    }

    private void setFAMTuneMemMaxHeapSizeRatio(String famTuneMemMaxHeapSizeRatio) throws AMTuneException {
        try {
            this.famTuneMemMaxHeapSizeRatio = AMTuneUtil.evaluteDivExp(famTuneMemMaxHeapSizeRatio.trim());
            this.famTuneMemMaxHeapSizeRatioExp = famTuneMemMaxHeapSizeRatio;
        }
        catch (Exception ex) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_MEM_MAX_HEAP_SIZE_RATIO");
            this.pLogger.log(Level.SEVERE, "setFAMTuneMemMaxHeapSizeRatio", "Error setting vlaue, make sure the value for AMTUNE_MEM_MAX_HEAP_SIZE_RATIO is valid expression.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public double getFAMTuneMemMaxHeapSizeRatio() {
        return this.famTuneMemMaxHeapSizeRatio;
    }

    public String getFAMTuneMemMaxHeapSizeRatioExp() {
        return this.famTuneMemMaxHeapSizeRatioExp;
    }

    private void setFAMTuneMemMinHeapSizeRatio(String famTuneMemMinHeapSizeRatio) throws AMTuneException {
        try {
            this.famTuneMemMinHeapSizeRatio = AMTuneUtil.evaluteDivExp(famTuneMemMinHeapSizeRatio);
        }
        catch (Exception ex) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_MEM_MIN_HEAP_SIZE_RATIO");
            this.pLogger.log(Level.SEVERE, "setFAMTuneMemMinHeapSizeRatio", "Error setting value, make sure the value for AMTUNE_MEM_MIN_HEAP_SIZE_RATIO is valid expresseion.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public double getFAMTuneMemMinHeapSizeRation() {
        return this.famTuneMemMinHeapSizeRatio;
    }

    private void setFAMTuneMinMemoryToUseInMB(String famTuneMinMemoryToUseInMB) throws AMTuneException {
        try {
            this.famTuneMinMemoryToUseInMB = Integer.parseInt(famTuneMinMemoryToUseInMB);
        }
        catch (Exception exp) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_MIN_MEMORY_TO_USE_IN_MB");
            this.pLogger.log(Level.SEVERE, "setFAMTuneMinMemoryToUseInMB", "Error setting value, make sure the value for AMTUNE_MIN_MEMORY_TO_USE_IN_MB is valid integer.");
            throw new AMTuneException(exp.getMessage());
        }
    }

    private void setFAMTuneMaxMemoryToUseInMB() throws Exception {
        if (AMTuneUtil.isLinux() || AMTuneUtil.isSunOs()) {
            if (this.getWebContainer().equals("WS7")) {
                if (AMTuneUtil.isLinux()) {
                    this.setFAMTuneMaxMemoryToUseInMB(this.confBundle.getString("AMTUNE_MAX_MEMORY_TO_USE_IN_MB_X86"));
                } else {
                    this.setFAMTuneMaxMemoryToUseInMB(this.confBundle.getString("AMTUNE_MAX_MEMORY_TO_USE_IN_MB_SOLARIS"));
                }
            } else if (AMTuneUtil.getOSPlatform().indexOf("sparc") == -1) {
                this.setFAMTuneMaxMemoryToUseInMB(this.confBundle.getString("AMTUNE_MAX_MEMORY_TO_USE_IN_MB_X86"));
            } else {
                this.setFAMTuneMaxMemoryToUseInMB(this.confBundle.getString("AMTUNE_MAX_MEMORY_TO_USE_IN_MB_SOLARIS"));
            }
        } else if (AMTuneUtil.isWindows2003()) {
            this.setFAMTuneMaxMemoryToUseInMB(Integer.toString(this.getFAMTuneMaxMemoryToUseInMBDefault()));
        }
    }

    public int getFAMTuneMinMemoryToUseInMB() {
        return this.famTuneMinMemoryToUseInMB;
    }

    private void setFAMTuneMaxMemoryToUseInMB(String famTuneMaxMemoryToUseInMB) throws AMTuneException {
        try {
            this.famTuneMaxMemoryToUseInMB = Integer.parseInt(famTuneMaxMemoryToUseInMB);
        }
        catch (Exception exp) {
            this.pLogger.log(Level.SEVERE, "setFAMTuneMaxMemoryToUseInMb", "Error setting value, is valid integer.");
            throw new AMTuneException(exp.getMessage());
        }
    }

    public int getFAMTuneMaxMemoryToUseInMB() {
        return this.famTuneMaxMemoryToUseInMB;
    }

    private void setFAMTuneMaxMemoryToUseInMBDefault(String famTuneMaxMemoryToUseInMBDefault) throws AMTuneException {
        try {
            this.famTuneMaxMemoryToUseInMBDefault = Integer.parseInt(famTuneMaxMemoryToUseInMBDefault);
        }
        catch (Exception exp) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("AMTUNE_MAX_MEMORY_TO_USE_IN_MB_DEFAULT");
            this.pLogger.log(Level.SEVERE, "setFAMTuneMaxMemoryToUseInMbDefault", "Error setting value, make sure the value for AMTUNE_MAX_MEMORY_TO_USE_IN_MB_DEFAULT is valid integer.");
            throw new AMTuneException(exp.getMessage());
        }
    }

    public int getFAMTuneMaxMemoryToUseInMBDefault() {
        return this.famTuneMaxMemoryToUseInMBDefault;
    }

    private void setFamAdminPassword(String famAdminPassword) throws AMTuneException {
        if (famAdminPassword == null || famAdminPassword.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("FAMADM_PASSWORD");
            this.pLogger.log(Level.SEVERE, "setFamAdminPassword", "Error setting FAM Administrator Password. Please check the value for the property FAMADM_PASSWORD");
            throw new AMTuneException("Invalid value for FAMADM_PASSWORD");
        }
        this.famAdminPassword = famAdminPassword.trim();
    }

    public String getFamAdminPassword() {
        return this.famAdminPassword;
    }

    private void setPerlBinDir(String perlBinDir) {
        this.perlBinDir = perlBinDir;
    }

    public String getPerlBinDir() {
        return this.perlBinDir;
    }

    private void calculateTuneParams() throws AMTuneException {
        try {
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.write("FAM tune ");
            this.mWriter.writelnLocaleMsg("pt-conf-info");
            this.mWriter.writeln("---------------------------------------------------------------------");
            if (this.isReviewMode) {
                this.mWriter.writelnLocaleMsg("pt-review-msg");
            } else {
                this.mWriter.writelnLocaleMsg("pt-change-msg");
            }
            this.mWriter.writeLocaleMsg("pt-os-msg");
            this.mWriter.writeln(this.tuneOS + " ");
            this.mWriter.writeLocaleMsg("pt-fam-msg");
            this.mWriter.writeln(this.tuneFAM + " ");
            this.mWriter.writeLocaleMsg("pt-ds-msg");
            this.mWriter.writeln(this.tuneDS + " ");
            this.mWriter.writeLocaleMsg("pt-web-msg");
            this.mWriter.writeln(this.tuneWebContainer + " ");
            if (this.webContainer.equals("WS7") || this.webContainer.equals("WS61")) {
                if (this.isJVM64BitAvailable) {
                    this.mWriter.writelnLocaleMsg("pt-ws-64-msg");
                } else {
                    this.mWriter.writelnLocaleMsg("pt-ws-32-msg");
                }
            }
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-conf-detecting");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.numCpus = Integer.parseInt(AMTuneUtil.getNumberOfCPUS());
            this.mWriter.writeLocaleMsg("pt-no-cpu");
            this.mWriter.writeln(this.numCpus + " ");
            this.gcThreads = this.numCpus;
            this.acceptorThreads = this.numCpus;
            this.mWriter.writeLocaleMsg("pt-ws-acceptor-msg");
            this.mWriter.writeln(this.acceptorThreads + " ");
            this.memAvail = Integer.parseInt(AMTuneUtil.getSystemMemory());
            this.mWriter.writeLocaleMsg("pt-mem-avail-msg");
            this.mWriter.writeln(this.memAvail + " ");
            this.memToUse = this.memAvail * this.getFAMTunePctMemoryToUse() / 100;
            if (this.memToUse > this.famTuneMaxMemoryToUseInMB && !this.isJVM64BitAvailable) {
                this.memToUse = this.famTuneMaxMemoryToUseInMB;
            }
            this.mWriter.writeLocaleMsg("pt-mem-to-use-msg");
            this.mWriter.writeln(this.memToUse + " ");
            if (this.memToUse == 0) {
                this.mWriter.writeLocaleMsg("pt-unable-mem-req");
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                throw new AMTuneException("Error computing memory requirements");
            }
            if (this.memToUse < this.getFAMTuneMinMemoryToUseInMB()) {
                this.mWriter.writelnLocaleMsg("pt-no-enough-mem");
                throw new AMTuneException("Not Enough memory.");
            }
            this.mWriter.writelnLocaleMsg("pt-enough-mem");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.mWriter.writelnLocaleMsg("pt-conf-calc-tune-params");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.maxHeapSize = (int)((double)this.memToUse * this.getFAMTuneMemMaxHeapSizeRatio());
            this.mWriter.writeLocaleMsg("pt-max-heap-size-msg");
            this.mWriter.writeln(this.maxHeapSize + " ");
            this.minHeapSize = this.maxHeapSize;
            this.mWriter.writeLocaleMsg("pt-min-heap-size-msg");
            this.mWriter.writeln(this.minHeapSize + " ");
            this.maxNewSize = (int)((double)this.maxHeapSize * 0.125);
            this.mWriter.writeLocaleMsg("pt-max-new-size-msg");
            this.mWriter.writeln(this.maxNewSize + " ");
            if (this.getWebContainer().equals("WS61")) {
                this.maxPermSize = (int)((double)this.maxHeapSize * 0.08333333333333333);
                this.mWriter.writeLocaleMsg("pt-max-perm-size-msg");
                this.mWriter.writeln(this.maxPermSize + " ");
            }
            this.cacheSize = (int)((double)this.maxHeapSize * 0.3333333333333333);
            this.mWriter.writeLocaleMsg("pt-cache-size-msg");
            this.mWriter.writeln(this.cacheSize + " ");
            this.sdkCacheSize = (int)((double)this.cacheSize * 0.6666666666666666);
            this.mWriter.writeLocaleMsg("pt-sdk-cache-size-msg");
            this.mWriter.writeln(this.sdkCacheSize + " ");
            this.numSDKCacheEntries = (int)((double)this.sdkCacheSize * 1024.0 / 8.0);
            this.mWriter.writeLocaleMsg("pt-no-sdk-cache-ent-msg");
            this.mWriter.writeln(this.numSDKCacheEntries + " ");
            this.sessionCacheSize = (int)((double)this.cacheSize * 0.3333333333333333);
            this.mWriter.writeLocaleMsg("pt-session-cache-size-msg");
            this.mWriter.writeln(this.sessionCacheSize + " ");
            this.numSessions = (int)((double)this.sessionCacheSize * 1024.0 / 4.0);
            this.mWriter.writeLocaleMsg("pt-no-session-cache-ent-msg");
            this.mWriter.writeln(this.numSessions + " ");
            this.amTuneMaxNoThreads = 0.0625 * (1024.0 / (double)this.getFAMTunePerThreadStackSizeInKB());
            this.amTuneMaxNoThreads64Bit = 0.0625 * (1024.0 / (double)this.getFAMTunePerThreadStackSizeInKB64Bit());
            this.maxThreads = 0;
            this.maxThreads = this.isJVM64BitAvailable ? (int)(this.amTuneMaxNoThreads64Bit * (double)this.maxHeapSize) : (int)(this.amTuneMaxNoThreads * (double)this.maxHeapSize);
            this.mWriter.writeLocaleMsg("pt-max-java-threads-msg");
            this.mWriter.writeln(this.maxThreads + " ");
            this.numOfMaxThreadPool = this.numRQThrottle = (int)((double)this.maxThreads * 0.4166666666666667);
            if (this.getWebContainer().equals("WS61")) {
                this.mWriter.writeLocaleMsg("pt-rq-thro-msg");
                this.mWriter.writeln(this.numRQThrottle + " ");
            } else {
                this.mWriter.writeLocaleMsg("pt-max-thread-pool-msg");
                this.mWriter.writeln(this.numOfMaxThreadPool + " ");
            }
            this.numLdapAuthThreads = (int)((double)this.maxThreads * 0.041666666666666664);
            this.mWriter.writeLocaleMsg("pt-ldap-auth-threads-msg");
            this.mWriter.writeln(this.numLdapAuthThreads + " ");
            this.numSMLdapThreads = (int)((double)this.maxThreads * 0.041666666666666664);
            this.mWriter.writeLocaleMsg("pt-sm-ldap-threads-msg");
            this.mWriter.writeln(this.numSMLdapThreads + " ");
            this.numNotificationThreads = this.numCpus * 3;
            this.mWriter.writeLocaleMsg("pt-notification-threads-msg");
            this.mWriter.writeln(this.numNotificationThreads + " ");
            this.numNotificationQueue = (int)(0.3 * (double)this.numSessions);
            this.numNotificationQueue = this.numNotificationQueue / 11 * 11;
            this.mWriter.writeLocaleMsg("pt-notification-queue-size-msg");
            this.mWriter.writeln(this.numNotificationQueue + " ");
            this.mWriter.writeln("=====================================================================");
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "calculateTuneParams", "Error while caliculating tuning parameters.");
            this.pLogger.logException("calculateTuneParams", ex);
            throw new AMTuneException(ex.getMessage());
        }
    }

    public int getAcceptorThreads() {
        return this.acceptorThreads;
    }

    public double getAmTuneMaxNoThreads() {
        return this.amTuneMaxNoThreads;
    }

    public double getAmTuneMaxNoThreads64Bit() {
        return this.amTuneMaxNoThreads64Bit;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public int getGcThreads() {
        return this.gcThreads;
    }

    public int getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public int getMaxNewSize() {
        return this.maxNewSize;
    }

    public int getMaxPermSize() {
        return this.maxPermSize;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMemAvail() {
        return this.memAvail;
    }

    public int getMemToUse() {
        return this.memToUse;
    }

    public int getMinHeapSize() {
        return this.minHeapSize;
    }

    public int getNumCpus() {
        return this.numCpus;
    }

    public int getNumLdapAuthThreads() {
        return this.numLdapAuthThreads;
    }

    public int getNumNotificationQueue() {
        return this.numNotificationQueue;
    }

    public int getNumNotificationThreads() {
        return this.numNotificationThreads;
    }

    public int getNumOfMaxThreadPool() {
        return this.numOfMaxThreadPool;
    }

    public int getNumRQThrottle() {
        return this.numRQThrottle;
    }

    public int getNumSDKCacheEntries() {
        return this.numSDKCacheEntries;
    }

    public int getNumSMLdapThreads() {
        return this.numSMLdapThreads;
    }

    public int getNumSessions() {
        return this.numSessions;
    }

    public int getSdkCacheSize() {
        return this.sdkCacheSize;
    }

    public int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    public WebContainerConfigInfoBase getWSConfigInfo() {
        return this.webConfigInfo;
    }

    private void setUMSMDSSame(String isUMSMDSSame) throws AMTuneException {
        if (isUMSMDSSame == null || isUMSMDSSame.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("IS_UM_SM_DATASTORE_SAME");
            this.pLogger.log(Level.SEVERE, "setUMSMDSSame", "Please check the value for the property IS_UM_SM_DATASTORE_SAME");
            throw new AMTuneException("Invalid value for IS_UM_SM_DATASTORE_SAME");
        }
        this.isUMSMDSSame = Boolean.parseBoolean(isUMSMDSSame);
    }

    public boolean isUMSMDSSame() {
        return this.isUMSMDSSame;
    }

    private void setTuneUMOnly(String tuneUMOnly) throws AMTuneException {
        if (tuneUMOnly == null || tuneUMOnly.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-inval-val-msg");
            AMTuneUtil.printErrorMsg("TUNE_UM_ONLY");
            this.pLogger.log(Level.SEVERE, "setTuneUMOnly", "Please check the value for the property TUNE_UM_ONLY");
            throw new AMTuneException("Invalid value for TUNE_UM_ONLY");
        }
        this.tuneUMOnly = Boolean.parseBoolean(tuneUMOnly);
    }

    public boolean isUMOnlyTune() {
        return this.tuneUMOnly;
    }

    public DSConfigInfo getDSConfigInfo() {
        return this.dsConfigInfo;
    }

    public DSConfigInfo getSMConfigInfo() {
        return this.smConfigInfo;
    }
}

