/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.common;

import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class AMTuneLogger {
    private static AMTuneLogger pLogger;
    private static boolean loggerInit;
    private static String logTemplate;
    private static Logger logger;
    private static SimpleFormatter simpleF;
    private SimpleDateFormat dateFormat;
    private FileHandler fileH;
    private String debugLogsFile;

    public static AMTuneLogger getLoggerInst() {
        if (!loggerInit) {
            pLogger = new AMTuneLogger();
        }
        return pLogger;
    }

    public static void setLogLevel(String logLevel) {
        if (logLevel != null) {
            logger.setLevel(Level.parse(logLevel));
        }
    }

    private AMTuneLogger() {
        try {
            logger = Logger.getLogger("com.sun.identity.tune");
            logger.setUseParentHandlers(false);
            simpleF = new SimpleFormatter();
            this.dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss:SSS a zzz");
            logTemplate = this.getClass().getName() + ".{0}: {1}";
            File logDir = new File(AMTuneUtil.getCurDir() + "../.." + "/" + "logs");
            if (!logDir.isDirectory()) {
                logDir.mkdir();
            }
            this.debugLogsFile = logDir.getAbsolutePath() + "/" + "amtune-debug-logs";
            this.fileH = new FileHandler(this.debugLogsFile);
            this.fileH.setFormatter(simpleF);
            logger.addHandler(this.fileH);
            loggerInit = true;
        }
        catch (Exception ex) {
            System.err.println("Couldn't initialize logger");
            ex.printStackTrace();
        }
    }

    public void log(Level level, String methodName, Object message) {
        Object[] args = new Object[]{methodName, message};
        String msg = MessageFormat.format(logTemplate, args);
        logger.log(level, msg);
    }

    public void logException(String methodName, Throwable th) {
        String prefix = this.dateFormat.format(new Date()) + ": " + Thread.currentThread().toString();
        StringBuffer buf = new StringBuffer(prefix);
        buf.append("\n");
        if (th != null) {
            buf.append('\n');
            StringWriter stBuf = new StringWriter(300);
            PrintWriter stackStream = new PrintWriter(stBuf);
            th.printStackTrace(stackStream);
            stackStream.flush();
            buf.append(stBuf.toString());
        }
        String message = buf.toString();
        Object[] args = new Object[]{methodName, message};
        logger.log(Level.SEVERE, MessageFormat.format(logTemplate, args));
    }

    public String getLogFilePath() {
        return this.debugLogsFile;
    }

    public void finalize() {
        if (this.fileH != null) {
            this.fileH.close();
        }
    }

    static {
        loggerInit = false;
    }
}

