/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.base;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.AMTuneLogger;
import com.sun.identity.tune.common.MessageWriter;
import com.sun.identity.tune.constants.WebContainerConstants;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.util.logging.Level;

public abstract class WebContainerConfigInfoBase
implements WebContainerConstants {
    private String hostName = AMTuneUtil.getHostName();
    private String containerBaseDir;
    private String containerInstanceName;
    private String containerInstanceDir;
    private String webContainer;
    protected AMTuneLogger pLogger = AMTuneLogger.getLoggerInst();
    protected MessageWriter mWriter = MessageWriter.getInstance();
    protected boolean isJVM64Bit = false;

    protected void setContainerBaseDir(String containerBaseDir) throws AMTuneException {
        if (containerBaseDir != null && containerBaseDir.trim().length() > 0) {
            File instDir = new File(containerBaseDir);
            if (!instDir.isDirectory()) {
                this.mWriter.writeLocaleMsg("pt-web-conf-dir-not-found");
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
                this.mWriter.writeln("CONTAINER_BASE_DIR");
                throw new AMTuneException("Invalid web container base directory");
            }
        } else {
            this.pLogger.log(Level.SEVERE, "setContainerBaseDir", "Please check the value for CONTAINER_BASE_DIR");
            throw new AMTuneException("Invalid web container base directory");
        }
        this.containerBaseDir = containerBaseDir.trim();
    }

    public String getContainerBaseDir() {
        return this.containerBaseDir;
    }

    protected void setContainerInstanceName(String containerInstanceName) {
        if (containerInstanceName != null && containerInstanceName.length() > 0) {
            this.containerInstanceName = containerInstanceName.trim();
        } else {
            containerInstanceName = AMTuneUtil.getHostName();
        }
    }

    public String getContainerInstanceName() {
        return this.containerInstanceName;
    }

    protected void setContainerInstanceDir(String containerInstanceDir) throws AMTuneException {
        if (containerInstanceDir != null && containerInstanceDir.trim().length() > 0) {
            File instDir = new File(containerInstanceDir);
            if (!instDir.isDirectory()) {
                this.mWriter.writeLocaleMsg("pt-web-inst-dir-not-found");
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
                this.mWriter.writeln("CONTAINER_INSTANCE_DIR");
                throw new AMTuneException("Invalid WebContainer Instance directory.");
            }
        } else {
            this.pLogger.log(Level.SEVERE, "setContainerInstanceDir", "Please check the value for CONTAINER_INSTANCE_DIR");
            throw new AMTuneException("Invalid web container instance directory");
        }
        this.containerInstanceDir = containerInstanceDir.trim();
    }

    public String getContainerInstanceDir() {
        return this.containerInstanceDir;
    }

    protected void setWebContainer(String webContainer) {
        this.webContainer = webContainer;
    }

    public String getWebContainer() {
        return this.webContainer;
    }

    protected void setJVM64BitEnabled(boolean jvm64bitEnabled) {
        this.isJVM64Bit = jvm64bitEnabled;
    }

    public boolean isJVM64Bit() {
        return this.isJVM64Bit;
    }
}

